/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE2_HANDLER_H__
#define __CHEROKEE2_HANDLER_H__

#include "common.h"
#include "buffer.h"
#include "http.h"


typedef enum {
	   hstat_unset,
	   hstat_sending,
	   hstat_forbidden,
	   hstat_file_not_found,
	   hstat_error
} cherokee_handler_status_t;


typedef ret_t (* func_new_t)                (void **handler, char *request);
typedef ret_t (* func_free_t)               (void  *handler);
typedef ret_t (* func_step_t)               (void  *handler, cherokee_buffer_t *buffer);
typedef int   (* func_get_content_length_t) (void  *handler);

typedef struct {
	   cherokee_http_t  status;
	   char            *redirect;

	   /* 	Pure virtual methods
	    */
	   func_free_t               free;
	   func_step_t               step;
	   func_get_content_length_t get_content_length;
	   
} cherokee_handler_t;

#define HANDLER(x) ((cherokee_handler_t *)(x))


ret_t cherokee_handler_init               (cherokee_handler_t  *hdl);

ret_t cherokee_handler_free               (cherokee_handler_t  *hdl);
ret_t cherokee_handler_step               (cherokee_handler_t  *hdl, cherokee_buffer_t *buffer);
int   cherokee_handler_get_content_length (cherokee_handler_t  *hdl);


#endif /* __CHEROKEE2_HANDLER_H__ */
