/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE2_DIRLIST_HANDLER_H__
#define __CHEROKEE2_DIRLIST_HANDLER_H__

#include <dirent.h>

#include "common.h"
#include "buffer.h"
#include "handler.h"


typedef struct {
	   cherokee_handler_t handler;

	   char *request;
	   DIR  *dir;

	   int page_begining;
	   int page_ending;
} cherokee_handler_dirlist_t;

#define DHANDLER(x)  ((cherokee_handler_dirlist_t *)(x))


ret_t cherokee_handler_dirlist_new (cherokee_handler_dirlist_t **hdl, char *request);

/* virtual methods implementation
 */
ret_t cherokee_handler_dirlist_free               (void *hdl);
ret_t cherokee_handler_dirlist_step               (void *hdl, cherokee_buffer_t *buffer);
int   cherokee_handler_dirlist_get_content_length (void *hdl);

#endif /* __CHEROKEE2_DIRLIST_HANDLER_H__ */
