/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;

public class UniqueName {
    private String key;
    private String patternKey;
    private List<COSName> resourceNames = Collections.emptyList();
    private List<COSName> patternNames = Collections.emptyList();

    public UniqueName(String key, COSDictionary sourcePageResources, List<COSName> patternNames, boolean disable, Rectangle destRect) {
        if (!disable) {
            key = key.split("#")[0];
            this.key = Integer.toString(key.hashCode());
            if (!patternNames.isEmpty()) {
                this.patternKey = Integer.toString((key + destRect.getX() + destRect.getY() + destRect.getWidth() + destRect.getHeight()).hashCode());
                this.patternNames = patternNames;
            }
            this.resourceNames = this.getResourceNames(sourcePageResources);
        }
    }

    protected String getName(COSName cn) {
        if (this.patternNames.contains(cn)) {
            return cn.getName() + this.patternKey;
        }
        if (this.resourceNames.contains(cn)) {
            return cn.getName() + this.key;
        }
        return cn.getName();
    }

    protected void writeName(StringBuilder sb, COSName cn) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        cn.writePDF((OutputStream)bos);
        String name = bos.toString("ISO-8859-1");
        sb.append(name);
        if (this.patternNames.contains(cn)) {
            sb.append(this.patternKey);
        }
        if (this.resourceNames.contains(cn)) {
            sb.append(this.key);
        }
    }

    private List<COSName> getResourceNames(COSDictionary sourcePageResources) {
        ArrayList<COSName> resourceNames = new ArrayList<COSName>();
        for (COSBase e : sourcePageResources.getValues()) {
            if (e instanceof COSObject) {
                e = ((COSObject)e).getObject();
            }
            if (!(e instanceof COSDictionary)) continue;
            COSDictionary d = (COSDictionary)e;
            for (COSName cosName : d.keySet()) {
                if (this.patternNames.contains(cosName)) continue;
                resourceNames.add(cosName);
            }
        }
        resourceNames.remove(COSName.S);
        return resourceNames;
    }
}

