/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.imageio;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.rendered.IndexImage;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterParams;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class PNGTranscoderImageIOWriteAdapter
implements PNGTranscoder.WriteAdapter {
    public void writeImage(PNGTranscoder pNGTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        TranscodingHints transcodingHints = pNGTranscoder.getTranscodingHints();
        int n = -1;
        if (transcodingHints.containsKey((Object)PNGTranscoder.KEY_INDEXED) && ((n = ((Integer)transcodingHints.get((Object)PNGTranscoder.KEY_INDEXED)).intValue()) == 1 || n == 2 || n == 4 || n == 8)) {
            bufferedImage = IndexImage.getIndexedImage(bufferedImage, 1 << n);
        }
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        float f = pNGTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n2 = (int)(25.4 / (double)f + 0.5);
        imageWriterParams.setResolution(n2);
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            imageWriter.writeImage(bufferedImage, outputStream, imageWriterParams);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException((Exception)iOException);
        }
    }
}

