/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime.activation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.ext.activation.SizeAwareDataSource;
import org.apache.axiom.mime.Part;
import org.apache.axiom.mime.activation.Util;

final class PartDataSource
implements SizeAwareDataSource {
    private final Part part;

    PartDataSource(Part part) {
        this.part = part;
    }

    public String getContentType() {
        return Util.getDataSourceContentType(this.part);
    }

    public InputStream getInputStream() throws IOException {
        return this.part.getInputStream(true);
    }

    public String getName() {
        return this.part.getContentID();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSize() {
        return this.part.getBlob().getSize();
    }
}

