/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.encoding.UrlDecoder;
import org.apache.wicket.util.string.Strings;

public final class RequestUtils {
    public static void decodeParameters(String queryString, PageParameters params) {
        RequestUtils.decodeParameters(queryString, params, RequestUtils.getCurrentCharset());
    }

    static void decodeParameters(String queryString, PageParameters params, Charset currentCharset) {
        if (Strings.indexOf(queryString, '?') == 0) {
            queryString = queryString.substring(1);
        }
        for (String paramTuple : Strings.split(queryString, '&')) {
            String[] bits = Strings.split(paramTuple, '=');
            if (bits.length == 2) {
                params.add(UrlDecoder.QUERY_INSTANCE.decode(bits[0], currentCharset), UrlDecoder.QUERY_INSTANCE.decode(bits[1], currentCharset), INamedParameters.Type.QUERY_STRING);
                continue;
            }
            params.add(UrlDecoder.QUERY_INSTANCE.decode(bits[0], currentCharset), "", INamedParameters.Type.QUERY_STRING);
        }
    }

    public static String removeDoubleDots(String path) {
        String[] segments = Strings.split(path, '/');
        ArrayList<String> newcomponents = new ArrayList<String>(Arrays.asList(segments));
        for (int i = 0; i < newcomponents.size(); ++i) {
            if (i >= newcomponents.size() - 1 || ((String)newcomponents.get(i)).length() <= 0 || !((String)newcomponents.get(i + 1)).equals("..")) continue;
            newcomponents.remove(i);
            newcomponents.remove(i);
            if ((i -= 2) >= -1) continue;
            i = -1;
        }
        String newpath = Strings.join("/", newcomponents);
        if (path.endsWith("/")) {
            return newpath + "/";
        }
        return newpath;
    }

    private RequestUtils() {
    }

    public static String toAbsolutePath(String requestPath, String relativePagePath) {
        StringBuilder result = requestPath.endsWith("/") ? new StringBuilder(requestPath) : new StringBuilder(requestPath.substring(0, requestPath.lastIndexOf(47) + 1));
        if (relativePagePath.startsWith("./")) {
            relativePagePath = relativePagePath.substring(2);
        }
        if (relativePagePath.startsWith("../")) {
            StringBuilder tempRelative = new StringBuilder(relativePagePath);
            while (tempRelative.indexOf("../") == 0) {
                tempRelative.delete(0, 3);
                result.setLength(result.length() - 1);
                result.delete(result.lastIndexOf("/") + 1, result.length());
            }
            result.append((CharSequence)tempRelative);
        } else {
            result.append(relativePagePath);
        }
        return result.toString();
    }

    private static Charset getDefaultCharset() {
        String charsetName = null;
        if (Application.exists()) {
            charsetName = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
        }
        if (Strings.isEmpty(charsetName)) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(charsetName);
    }

    private static Charset getCurrentCharset() {
        return RequestCycle.get().getRequest().getCharset();
    }

    public static Charset getCharset(HttpServletRequest request) {
        String charsetName;
        Charset charset = null;
        if (request != null && (charsetName = request.getCharacterEncoding()) != null) {
            try {
                charset = Charset.forName(charsetName);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        if (charset == null) {
            charset = RequestUtils.getDefaultCharset();
        }
        return charset;
    }
}

