/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.Strings;

public class ResourceUtil {
    private static final Pattern ESCAPED_ATTRIBUTE_PATTERN = Pattern.compile("(\\w)~(\\w)");

    public static ResourceReference.UrlAttributes decodeResourceReferenceAttributes(String encodedAttributes) {
        Locale locale = null;
        String style = null;
        String variation = null;
        if (!Strings.isEmpty((CharSequence)encodedAttributes)) {
            String[] split = Strings.split((String)encodedAttributes, (char)'-');
            locale = ResourceUtil.parseLocale(split[0]);
            if (split.length == 2) {
                style = Strings.defaultIfEmpty((String)ResourceUtil.unescapeAttributesSeparator(split[1]), null);
            } else if (split.length == 3) {
                style = Strings.defaultIfEmpty((String)ResourceUtil.unescapeAttributesSeparator(split[1]), null);
                variation = Strings.defaultIfEmpty((String)ResourceUtil.unescapeAttributesSeparator(split[2]), null);
            }
        }
        return new ResourceReference.UrlAttributes(locale, style, variation);
    }

    public static ResourceReference.UrlAttributes decodeResourceReferenceAttributes(Url url) {
        Url.QueryParameter param;
        Args.notNull((Object)url, (String)"url");
        if (url.getQueryParameters().size() > 0 && Strings.isEmpty((CharSequence)(param = (Url.QueryParameter)url.getQueryParameters().get(0)).getValue())) {
            return ResourceUtil.decodeResourceReferenceAttributes(param.getName());
        }
        return new ResourceReference.UrlAttributes(null, null, null);
    }

    public static String encodeResourceReferenceAttributes(ResourceReference.UrlAttributes attributes) {
        boolean styleEmpty;
        if (attributes == null || attributes.getLocale() == null && attributes.getStyle() == null && attributes.getVariation() == null) {
            return null;
        }
        StringBuilder res = new StringBuilder(32);
        if (attributes.getLocale() != null) {
            res.append(attributes.getLocale());
        }
        if (!(styleEmpty = Strings.isEmpty((CharSequence)attributes.getStyle()))) {
            res.append('-');
            res.append(ResourceUtil.escapeAttributesSeparator(attributes.getStyle()));
        }
        if (!Strings.isEmpty((CharSequence)attributes.getVariation())) {
            if (styleEmpty) {
                res.append("--");
            } else {
                res.append('-');
            }
            res.append(ResourceUtil.escapeAttributesSeparator(attributes.getVariation()));
        }
        return res.toString();
    }

    public static void encodeResourceReferenceAttributes(Url url, ResourceReference reference) {
        Args.notNull((Object)url, (String)"url");
        Args.notNull((Object)reference, (String)"reference");
        String encoded = ResourceUtil.encodeResourceReferenceAttributes(reference.getUrlAttributes());
        if (!Strings.isEmpty((CharSequence)encoded)) {
            url.getQueryParameters().add(new Url.QueryParameter(encoded, ""));
        }
    }

    public static CharSequence escapeAttributesSeparator(String attribute) {
        CharSequence tmp = Strings.replaceAll((CharSequence)attribute, (CharSequence)"~", (CharSequence)"~~");
        return Strings.replaceAll((CharSequence)tmp, (CharSequence)"-", (CharSequence)"~");
    }

    public static Locale parseLocale(String locale) {
        if (Strings.isEmpty((CharSequence)locale)) {
            return null;
        }
        String[] parts = locale.toLowerCase(Locale.ROOT).split("_", 3);
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        return null;
    }

    public static String readString(IResourceStream resourceStream) {
        return ResourceUtil.readString(resourceStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(IResourceStream resourceStream, Charset charset) {
        String string;
        InputStream stream = resourceStream.getInputStream();
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            string = new String(bytes, charset.name());
        }
        catch (Throwable throwable) {
            try {
                resourceStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new WicketRuntimeException("failed to read string from " + resourceStream, e);
            }
            catch (ResourceStreamNotFoundException e) {
                throw new WicketRuntimeException("failed to locate stream from " + resourceStream, e);
            }
        }
        resourceStream.close();
        return string;
    }

    public static String unescapeAttributesSeparator(String attribute) {
        String tmp = ESCAPED_ATTRIBUTE_PATTERN.matcher(attribute).replaceAll("$1-$2");
        return Strings.replaceAll((CharSequence)tmp, (CharSequence)"~~", (CharSequence)"~").toString();
    }

    private ResourceUtil() {
    }
}

