/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.javax;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketConnection;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaxWebSocketConnection
extends AbstractWebSocketConnection {
    private static final Logger LOG = LoggerFactory.getLogger(JavaxWebSocketConnection.class);
    private final Session session;

    public JavaxWebSocketConnection(Session session, AbstractWebSocketProcessor webSocketProcessor) {
        super(webSocketProcessor);
        this.session = (Session)Args.notNull((Object)session, (String)"connection");
    }

    public boolean isOpen() {
        return this.session.isOpen();
    }

    public synchronized void close(int code, String reason) {
        if (this.isOpen()) {
            try {
                this.session.close(new CloseReason((CloseReason.CloseCode)new CloseCode(code), reason));
            }
            catch (IOException iox) {
                LOG.error("An error occurred while closing WebSocket session", (Throwable)iox);
            }
        }
    }

    public synchronized IWebSocketConnection sendMessage(String message) throws IOException {
        this.checkClosed();
        this.session.getBasicRemote().sendText(message);
        return this;
    }

    public synchronized IWebSocketConnection sendMessage(byte[] message, int offset, int length) throws IOException {
        this.checkClosed();
        ByteBuffer buf = ByteBuffer.wrap(message, offset, length);
        this.session.getBasicRemote().sendBinary(buf);
        return this;
    }

    private void checkClosed() {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection is closed.");
        }
    }

    private static class CloseCode
    implements CloseReason.CloseCode {
        private final int code;

        private CloseCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

