/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import java.io.Serializable;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Conversation;
import javax.inject.Inject;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.cdi.ConversationPropagation;
import org.apache.wicket.cdi.ICdiAwareRequestCycleListener;
import org.apache.wicket.cdi.IConversationPropagation;
import org.apache.wicket.cdi.NonContextual;
import org.apache.wicket.core.request.handler.BufferedResponseRequestHandler;
import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationPropagator
implements IRequestCycleListener {
    private static final Logger logger = LoggerFactory.getLogger(ConversationPropagator.class);
    private static final MetaDataKey<Boolean> CONVERSATION_STARTED_KEY = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };
    private static final MetaDataKey<String> CONVERSATION_ID_KEY = new MetaDataKey<String>(){
        private static final long serialVersionUID = 1L;
    };
    public static final String CID = "cid";
    private final IConversationPropagation propagation;
    private final Application application;
    @Inject
    private Conversation conversation;

    public ConversationPropagator(Application application, IConversationPropagation propagation) {
        Args.notNull((Object)application, (String)"application");
        Args.notNull((Object)propagation, (String)"propagation");
        if (propagation == ConversationPropagation.NONE) {
            throw new IllegalArgumentException("If propagation is NONE do not set up the propagator");
        }
        this.application = application;
        this.propagation = propagation;
        NonContextual.of(ConversationPropagator.class).postConstruct(this);
    }

    public IConversationPropagation getPropagation() {
        return this.propagation;
    }

    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        if (this.activateForHandler(handler)) {
            logger.debug("Activating conversation {}", (Object)this.conversation.getId());
            this.fireOnAfterConversationStarted(cycle);
        }
    }

    private void fireOnAfterConversationStarted(RequestCycle cycle) {
        cycle.setMetaData(CONVERSATION_STARTED_KEY, (Object)true);
        for (IRequestCycleListener listener : this.application.getRequestCycleListeners()) {
            if (!(listener instanceof ICdiAwareRequestCycleListener)) continue;
            ((ICdiAwareRequestCycleListener)listener).onAfterConversationActivated(cycle);
        }
    }

    public void onRequestHandlerExecuted(RequestCycle cycle, IRequestHandler handler) {
        try {
            if (this.conversation.isTransient()) {
                return;
            }
        }
        catch (ContextNotActiveException cnax) {
            logger.debug("There is no active context for the requested scope!", (Throwable)cnax);
            return;
        }
        if (this.propagation.propagatesVia(handler, ConversationPropagator.getPage(handler))) {
            logger.debug("Propagating non-transient conversation {} via page parameters of handler {}", (Object)this.conversation.getId(), (Object)handler);
            PageParameters parameters = this.getPageParameters(handler);
            if (parameters != null) {
                parameters.set(CID, (Object)this.conversation.getId());
                ConversationPropagator.markPageWithConversationId(handler, this.conversation.getId());
            }
        }
    }

    public void onUrlMapped(RequestCycle cycle, IRequestHandler handler, Url url) {
        if (handler instanceof ResourceReferenceRequestHandler && ((ResourceReferenceRequestHandler)handler).getResourceReference() instanceof PackageResourceReference) {
            return;
        }
        if (this.conversation.isTransient()) {
            return;
        }
        if (this.propagation.propagatesVia(handler, ConversationPropagator.getPage(handler))) {
            logger.debug("Propagating non-transient conversation {} via url", (Object)this.conversation.getId());
            url.setQueryParameter(CID, (Object)this.conversation.getId());
            ConversationPropagator.markPageWithConversationId(handler, this.conversation.getId());
        }
    }

    public void onDetach(RequestCycle cycle) {
        if (!Boolean.TRUE.equals(cycle.getMetaData(CONVERSATION_STARTED_KEY))) {
            return;
        }
        logger.debug("Deactivating conversation {}", (Object)this.conversation.getId());
        for (IRequestCycleListener listener : this.application.getRequestCycleListeners()) {
            if (!(listener instanceof ICdiAwareRequestCycleListener)) continue;
            ((ICdiAwareRequestCycleListener)listener).onBeforeConversationDeactivated(cycle);
        }
    }

    protected boolean activateForHandler(IRequestHandler handler) {
        if (handler != null) {
            String handlerClassName = Classes.name(handler.getClass());
            if (handler instanceof BufferedResponseRequestHandler) {
                return false;
            }
            if ("org.apache.wicket.protocol.ws.api.WebSocketMessageBroadcastHandler".equals(handlerClassName)) {
                return false;
            }
            if ("org.apache.wicket.protocol.ws.api.WebSocketRequestHandler".equals(handlerClassName)) {
                return false;
            }
        }
        return true;
    }

    public static void markPageWithConversationId(IRequestHandler handler, String cid) {
        Page page = ConversationPropagator.getPage(handler);
        if (page != null) {
            page.setMetaData(CONVERSATION_ID_KEY, (Serializable)((Object)cid));
        }
    }

    public static String getConversationIdFromPage(Page page) {
        return (String)((Object)page.getMetaData(CONVERSATION_ID_KEY));
    }

    public static void removeConversationIdFromPage(Page page) {
        page.setMetaData(CONVERSATION_ID_KEY, null);
    }

    public static Page getPage(IRequestHandler handler) {
        IPageRequestHandler pageHandler;
        while (handler instanceof IRequestHandlerDelegate) {
            handler = ((IRequestHandlerDelegate)handler).getDelegateHandler();
        }
        if (handler instanceof IPageRequestHandler && (pageHandler = (IPageRequestHandler)handler).isPageInstanceCreated()) {
            return (Page)pageHandler.getPage();
        }
        return null;
    }

    protected PageParameters getPageParameters(IRequestHandler handler) {
        if (handler instanceof IPageClassRequestHandler) {
            IPageClassRequestHandler pageHandler = (IPageClassRequestHandler)handler;
            return pageHandler.getPageParameters();
        }
        return null;
    }
}

