/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.instrument;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.instrument.Instrumentation;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationObjectSizeOfStrategy
implements WicketObjects.IObjectSizeOfStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(InstrumentationObjectSizeOfStrategy.class);
    private final Instrumentation instrumentation;

    public InstrumentationObjectSizeOfStrategy(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public long sizeOf(Serializable obj) {
        if (obj == null) {
            return 0L;
        }
        try {
            SizeRecodingOuputStream recorder = new SizeRecodingOuputStream();
            recorder.writeObject(obj);
            return recorder.getTotalSize();
        }
        catch (IOException e) {
            LOG.error("Error calculating size of object", (Throwable)e);
            return -1L;
        }
    }

    private final class SizeRecodingOuputStream
    extends ObjectOutputStream {
        private long totalSize;

        public SizeRecodingOuputStream() throws IOException {
            super(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            });
            this.totalSize = 0L;
            this.enableReplaceObject(true);
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj != null) {
                this.totalSize += InstrumentationObjectSizeOfStrategy.this.instrumentation.getObjectSize(obj);
            }
            return obj;
        }
    }
}

