/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.wizard.CancelButton;
import org.apache.wicket.extensions.wizard.FinishButton;
import org.apache.wicket.extensions.wizard.IDefaultButtonProvider;
import org.apache.wicket.extensions.wizard.IWizard;
import org.apache.wicket.extensions.wizard.IWizardModel;
import org.apache.wicket.extensions.wizard.LastButton;
import org.apache.wicket.extensions.wizard.NextButton;
import org.apache.wicket.extensions.wizard.PreviousButton;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.panel.Panel;

public class WizardButtonBar
extends Panel
implements IDefaultButtonProvider {
    private static final long serialVersionUID = 1L;
    private final IWizard wizard;

    public WizardButtonBar(String id, IWizard wizard) {
        super(id);
        this.wizard = wizard;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.newPreviousButton("previous", this.wizard)});
        this.add(new Component[]{this.newNextButton("next", this.wizard)});
        this.add(new Component[]{this.newLastButton("last", this.wizard)});
        this.add(new Component[]{this.newCancelButton("cancel", this.wizard)});
        this.add(new Component[]{this.newFinishButton("finish", this.wizard)});
    }

    @Override
    public IFormSubmittingComponent getDefaultButton(IWizardModel model) {
        if (model.isNextAvailable()) {
            return (IFormSubmittingComponent)this.get("next");
        }
        if (model.isLastAvailable()) {
            return (IFormSubmittingComponent)this.get("last");
        }
        if (model.isLastStep(model.getActiveStep())) {
            return (IFormSubmittingComponent)this.get("finish");
        }
        return null;
    }

    protected PreviousButton newPreviousButton(String id, IWizard wizard) {
        return new PreviousButton(id, wizard);
    }

    protected NextButton newNextButton(String id, IWizard wizard) {
        return new NextButton(id, wizard);
    }

    protected LastButton newLastButton(String id, IWizard wizard) {
        return new LastButton(id, wizard);
    }

    protected CancelButton newCancelButton(String id, IWizard wizard) {
        return new CancelButton(id, wizard);
    }

    protected FinishButton newFinishButton(String id, IWizard wizard) {
        return new FinishButton(id, wizard);
    }
}

