/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.atmosphere.tester;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.atmosphere.AtmosphereBehavior;
import org.apache.wicket.atmosphere.EventBus;
import org.apache.wicket.atmosphere.tester.TesterAtmosphereBehavior;
import org.apache.wicket.atmosphere.tester.TesterBroadcaster;
import org.apache.wicket.atmosphere.tester.TesterBroadcasterFactory;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.mock.MockHttpServletResponse;
import org.apache.wicket.util.tester.WicketTester;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;

public class AtmosphereTester {
    private final EventBus eventBus;
    private final WicketTester wicketTester;
    private MockHttpServletResponse suspendedResponse;
    private MockHttpServletResponse lastResponse;

    public AtmosphereTester(WicketTester wicketTester, Page page) {
        this.wicketTester = wicketTester;
        WebApplication application = wicketTester.getApplication();
        TesterBroadcaster broadcaster = this.createBroadcaster();
        if (EventBus.isInstalled((Application)application)) {
            this.eventBus = EventBus.get((Application)application);
            this.eventBus.setBroadcaster((Broadcaster)broadcaster);
        } else {
            this.eventBus = new EventBus(application, (Broadcaster)broadcaster);
        }
        this.initialize(wicketTester, page);
    }

    private void initialize(WicketTester wicketTester, Page page) {
        List behaviors = page.getBehaviors(AtmosphereBehavior.class);
        page.remove((Behavior[])behaviors.toArray(new AtmosphereBehavior[behaviors.size()]));
        TesterAtmosphereBehavior atmosphereBehavior = new TesterAtmosphereBehavior(wicketTester, this.eventBus);
        page.add(new Behavior[]{atmosphereBehavior});
        wicketTester.startPage(page);
        wicketTester.getRequest().setHeader("X-Atmosphere-Transport", AtmosphereResource.TRANSPORT.WEBSOCKET.name());
        this.suspendedResponse = wicketTester.getResponse();
        wicketTester.executeBehavior((AbstractAjaxBehavior)atmosphereBehavior);
    }

    private TesterBroadcaster createBroadcaster() {
        TesterBroadcaster broadcaster = new TesterBroadcaster();
        AtmosphereFramework framework = new AtmosphereFramework();
        AtmosphereConfig config = new AtmosphereConfig(framework);
        TesterBroadcasterFactory broadcasterFactory = new TesterBroadcasterFactory(config, broadcaster);
        framework.setBroadcasterFactory((BroadcasterFactory)broadcasterFactory);
        broadcaster.initialize("wicket-atmosphere-tester", config);
        return broadcaster;
    }

    public String getPushedResponse() {
        return this.suspendedResponse != null ? this.suspendedResponse.getDocument() : null;
    }

    public AtmosphereTester resetResponse() {
        if (this.suspendedResponse != null) {
            this.suspendedResponse.reset();
        }
        return this;
    }

    public AtmosphereTester post(Object message) {
        this.eventBus.post(message);
        return this;
    }

    public AtmosphereTester post(Object message, String resourceUuid) {
        this.eventBus.post(message, resourceUuid);
        return this;
    }

    public AtmosphereTester switchOnTestMode() {
        this.lastResponse = this.wicketTester.getLastResponse();
        this.wicketTester.setLastResponse(this.suspendedResponse);
        return this;
    }

    public AtmosphereTester switchOffTestMode() {
        if (this.lastResponse != null) {
            this.wicketTester.setLastResponse(this.lastResponse);
            this.lastResponse = null;
        }
        return this;
    }
}

