/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.atmosphere;

import javax.servlet.http.Cookie;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.time.Time;
import org.atmosphere.cpr.AtmosphereResponse;

class AtmosphereWebResponse
extends WebResponse {
    private final AtmosphereResponse response;
    private final AppendingStringBuffer out;
    private boolean redirect;

    AtmosphereWebResponse(AtmosphereResponse response) {
        this.response = response;
        this.out = new AppendingStringBuffer(128);
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public void clearCookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void setDateHeader(String name, Time date) {
        this.response.setDateHeader(name, date.getMilliseconds());
    }

    public void setContentLength(long length) {
        this.response.addHeader("Content-Length", Long.toString(length));
    }

    public void setContentType(String mimeType) {
        this.response.setContentType(mimeType);
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public void sendError(int sc, String msg) {
        throw new UnsupportedOperationException();
    }

    public String encodeRedirectURL(CharSequence url) {
        return url.toString();
    }

    public void sendRedirect(String url) {
        this.out.clear();
        this.out.append("<ajax-response><redirect><![CDATA[" + url + "]]></redirect></ajax-response>");
        this.redirect = true;
    }

    public void write(byte[] array) {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] array, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public String encodeURL(CharSequence url) {
        return url.toString();
    }

    public Object getContainerResponse() {
        return this.response;
    }

    public boolean isRedirect() {
        return false;
    }

    public void reset() {
        this.out.clear();
    }

    public void flush() {
    }

    public void write(CharSequence sequence) {
        if (!this.redirect) {
            this.out.append((Object)sequence);
        }
    }

    public CharSequence getBuffer() {
        return this.out;
    }

    public String toString() {
        return this.out.toString();
    }
}

