/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.requestlogger;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.io.Serializable;
import org.apache.wicket.protocol.http.AbstractRequestLogger;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.RequestLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRequestLogger
extends AbstractRequestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLogger.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonRequestLogger() {
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        SimpleFilterProvider filters = new SimpleFilterProvider();
        filters.addFilter("default", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"eventTarget", "responseTarget"}));
        this.mapper.setFilterProvider((FilterProvider)filters);
        this.mapper.setAnnotationIntrospector((AnnotationIntrospector)new FilteredIntrospector());
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }

    protected void log(IRequestLogger.RequestData rd, IRequestLogger.SessionData sd) {
        if (LOG.isInfoEnabled()) {
            LOG.info(this.getLogString(rd, sd));
        }
    }

    protected String getLogString(IRequestLogger.RequestData rd, IRequestLogger.SessionData sd) {
        try {
            return this.getMapper().writeValueAsString((Object)new RequestSessionTuple(rd, sd));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class RequestSessionTuple
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IRequestLogger.RequestData request;
        private final IRequestLogger.SessionData session;

        public RequestSessionTuple(IRequestLogger.RequestData request, IRequestLogger.SessionData session) {
            this.request = request;
            this.session = session;
        }

        public IRequestLogger.RequestData getRequest() {
            return this.request;
        }

        public IRequestLogger.SessionData getSession() {
            return this.session;
        }
    }

    private static final class FilteredIntrospector
    extends JacksonAnnotationIntrospector {
        private FilteredIntrospector() {
        }

        public Object findFilterId(AnnotatedClass ac) {
            return "default";
        }

        public Object findFilterId(Annotated a) {
            return "default";
        }
    }
}

