/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;

public class CompoundValidator<T>
extends Behavior
implements IValidator<T> {
    private static final long serialVersionUID = 1L;
    private final List<IValidator<T>> validators = new ArrayList<IValidator<T>>(2);

    public final CompoundValidator<T> add(IValidator<T> validator) {
        Args.notNull(validator, (String)"validator");
        this.validators.add(validator);
        return this;
    }

    @Override
    public final void validate(IValidatable<T> validatable) {
        Iterator<IValidator<T>> it = this.validators.iterator();
        while (it.hasNext() && validatable.isValid()) {
            it.next().validate(validatable);
        }
    }

    public final List<IValidator<T>> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    @Override
    public void beforeRender(Component component) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).beforeRender(component);
        }
    }

    @Override
    public void afterRender(Component component) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).afterRender(component);
        }
    }

    @Override
    public void bind(Component component) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).bind(component);
        }
    }

    @Override
    public void unbind(Component component) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).unbind(component);
        }
    }

    @Override
    public void detach(Component component) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).detach(component);
        }
    }

    @Override
    public void onException(Component component, RuntimeException exception) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).onException(component, exception);
        }
    }

    @Override
    public boolean getStatelessHint(Component component) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior) || ((Behavior)((Object)validator)).getStatelessHint(component)) continue;
            return false;
        }
        return super.getStatelessHint(component);
    }

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).onComponentTag(component, tag);
        }
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).renderHead(component, response);
        }
    }

    @Override
    public void onConfigure(Component component) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).onConfigure(component);
        }
    }

    @Override
    public void onEvent(Component component, IEvent<?> event) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).onEvent(component, event);
        }
    }

    @Override
    public void onRemove(Component component) {
        for (IValidator<T> validator : this.validators) {
            if (!(validator instanceof Behavior)) continue;
            ((Behavior)((Object)validator)).onRemove(component);
        }
    }
}

