/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.renderStrategy;

import java.util.Iterator;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.application.HeaderContributorListenerCollection;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.internal.InlineEnclosure;
import org.apache.wicket.markup.renderStrategy.ChildFirstHeaderRenderStrategy;
import org.apache.wicket.markup.renderStrategy.IHeaderRenderStrategy;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public abstract class AbstractHeaderRenderStrategy
implements IHeaderRenderStrategy {
    public static IHeaderRenderStrategy get() {
        String className = System.getProperty("Wicket_HeaderRenderStrategy");
        if (className != null) {
            try {
                Class<?> clazz = Application.get().getApplicationSettings().getClassResolver().resolveClass(className);
                if (clazz != null) {
                    return (IHeaderRenderStrategy)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new ChildFirstHeaderRenderStrategy();
    }

    @Override
    public void renderHeader(HtmlHeaderContainer headerContainer, HtmlHeaderContainer.HeaderStreamState headerStreamState, Component rootComponent) {
        Args.notNull((Object)headerContainer, (String)"headerContainer");
        Args.notNull((Object)rootComponent, (String)"rootComponent");
        this.renderApplicationLevelHeaders(headerContainer);
        this.renderRootComponent(headerContainer, headerStreamState, rootComponent);
        this.renderChildHeaders(headerContainer, rootComponent);
    }

    protected void renderRootComponent(HtmlHeaderContainer headerContainer, HtmlHeaderContainer.HeaderStreamState headerStreamState, Component rootComponent) {
        headerContainer.renderHeaderTagBody(headerStreamState);
        rootComponent.internalRenderHead(headerContainer);
        if (rootComponent instanceof InlineEnclosure) {
            this.renderInlineEnclosure(headerContainer, (InlineEnclosure)rootComponent);
        }
    }

    protected void renderInlineEnclosure(HtmlHeaderContainer container, InlineEnclosure enclosure) {
        final String childId = enclosure.getChildId();
        Component enclosureController = enclosure.getParent().visitChildren(new IVisitor<Component, Component>(){

            public void component(Component object, IVisit<Component> visit) {
                if (object.getId().equals(childId)) {
                    visit.stop((Object)object);
                } else {
                    visit.dontGoDeeper();
                }
            }
        });
        if (enclosureController != null) {
            enclosureController.internalRenderHead(container);
        }
    }

    protected abstract void renderChildHeaders(HtmlHeaderContainer var1, Component var2);

    protected final void renderApplicationLevelHeaders(HtmlHeaderContainer headerContainer) {
        Args.notNull((Object)headerContainer, (String)"headerContainer");
        if (Application.exists()) {
            HeaderContributorListenerCollection headerContributorListenerCollection = Application.get().getHeaderContributorListeners();
            IHeaderResponse headerResponse = headerContainer.getHeaderResponse();
            Iterator i$ = headerContributorListenerCollection.iterator();
            while (i$.hasNext()) {
                IHeaderContributor listener = (IHeaderContributor)i$.next();
                listener.renderHead(headerResponse);
            }
        }
    }
}

