/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.lang.Args;

public final class HeaderPartContainer
extends WebMarkupContainer
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private final MarkupContainer container;
    private final String scope;

    public HeaderPartContainer(String id, MarkupContainer container, IMarkupFragment markup) {
        super(id);
        Args.notNull((Object)container, (String)"container");
        Args.notNull((Object)markup, (String)"markup");
        this.setMarkup(markup);
        this.container = container;
        this.scope = this.getScopeFromMarkup();
        this.setRenderBodyOnly(true);
    }

    private String getScopeFromMarkup() {
        IMarkupFragment markup = this.getMarkup();
        String namespace = markup.getMarkupResourceStream().getWicketNamespace();
        ComponentTag tag = (ComponentTag)markup.get(0);
        return tag.getAttributes().getString(namespace + ":scope");
    }

    public final String getScope() {
        return this.scope;
    }

    @Override
    public final Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        return this.container.get(tag.getId());
    }
}

