/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.tree.BaseTree;
import org.apache.wicket.extensions.markup.html.tree.LabelIconPanel;
import org.apache.wicket.model.IModel;

public class LinkIconPanel
extends LabelIconPanel {
    private static final long serialVersionUID = 1L;

    public LinkIconPanel(String id, IModel<Object> model, BaseTree tree) {
        super(id, model, tree);
    }

    @Override
    protected void addComponents(final IModel<Object> model, final BaseTree tree) {
        BaseTree.ILinkCallback callback = new BaseTree.ILinkCallback(){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                LinkIconPanel.this.onNodeLinkClicked(model.getObject(), tree, target);
            }
        };
        MarkupContainer link = tree.newLink("iconLink", callback);
        this.add(new Component[]{link});
        link.add(new Component[]{this.newImageComponent("icon", tree, model)});
        link = tree.newLink("contentLink", callback);
        this.add(new Component[]{link});
        link.add(new Component[]{this.newContentComponent("content", tree, model)});
    }

    protected void onNodeLinkClicked(Object node, BaseTree tree, AjaxRequestTarget target) {
        tree.getTreeState().selectNode(node, !tree.getTreeState().isNodeSelected(node));
        if (target != null) {
            tree.updateTree(target);
        }
    }
}

