/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.iterator;

import java.util.Iterator;
import org.apache.wicket.util.collections.ArrayListStack;
import org.apache.wicket.util.lang.Args;

@Deprecated
public abstract class AbstractHierarchyIterator<N, I extends N>
implements Iterator<I>,
Iterable<I> {
    private ArrayListStack<LevelIterator<N>> stack = new ArrayListStack();
    private LevelIterator<N> data;
    private boolean traverse;
    private boolean childFirst;
    private boolean skipRemainingSiblings;
    private boolean hasNextWasLast;

    public AbstractHierarchyIterator(N root) {
        Args.notNull(root, (String)"root");
        if (this.hasChildren(root)) {
            this.data = new LevelIterator<N>(root, this.newIterator(root));
        }
    }

    public final void setChildFirst(boolean childFirst) {
        this.childFirst = childFirst;
    }

    protected abstract boolean hasChildren(N var1);

    protected abstract Iterator<N> newIterator(N var1);

    @Override
    public boolean hasNext() {
        if (this.data == null) {
            return false;
        }
        if (this.hasNextWasLast) {
            return true;
        }
        this.hasNextWasLast = true;
        if (this.skipRemainingSiblings) {
            this.skipRemainingSiblings = false;
            return this.moveUp();
        }
        if (!this.childFirst && this.traverse) {
            if (!this.moveDown(((LevelIterator)this.data).lastNode)) {
                return false;
            }
            this.hasNextWasLast = true;
            return true;
        }
        return this.nextNode();
    }

    private boolean moveDown(N node) {
        this.stack.push(this.data);
        this.data = new LevelIterator<N>(node, this.newIterator(node));
        return this.nextNode();
    }

    protected boolean onFilter(N node) {
        return true;
    }

    protected boolean onTraversalFilter(N node) {
        return true;
    }

    private boolean nextNode() {
        while (this.data.hasNext()) {
            ((LevelIterator)this.data).lastNode = this.data.next();
            this.traverse = this.hasChildren(((LevelIterator)this.data).lastNode);
            if (this.traverse) {
                this.traverse = this.onTraversalFilter(((LevelIterator)this.data).lastNode);
            }
            if (this.childFirst && this.traverse && !this.moveDown(((LevelIterator)this.data).lastNode)) {
                return false;
            }
            if (this.onFilter(((LevelIterator)this.data).lastNode)) {
                return true;
            }
            if (!this.childFirst && this.traverse) {
                if (!this.moveDown(((LevelIterator)this.data).lastNode)) {
                    return false;
                }
                if (this.data == null) {
                    return false;
                }
                this.hasNextWasLast = true;
                return true;
            }
            if (!this.skipRemainingSiblings) continue;
            this.skipRemainingSiblings = false;
            break;
        }
        return this.moveUp();
    }

    private boolean moveUp() {
        if (this.data == null) {
            return false;
        }
        if (this.stack.isEmpty()) {
            this.data = null;
            return false;
        }
        this.data = (LevelIterator)this.stack.pop();
        if (this.childFirst) {
            this.hasNextWasLast = true;
            if (this.onFilter(((LevelIterator)this.data).lastNode)) {
                return true;
            }
            return this.nextNode();
        }
        if (this.data.hasNext()) {
            return this.nextNode();
        }
        return this.moveUp();
    }

    @Override
    public I next() {
        if (this.data == null) {
            return null;
        }
        if (!this.hasNextWasLast && !this.hasNext()) {
            return null;
        }
        this.hasNextWasLast = false;
        return (I)((LevelIterator)this.data).lastNode;
    }

    @Override
    public void remove() {
        if (this.data == null) {
            throw new IllegalStateException("Already reached the end of the iterator.");
        }
        this.data.remove();
    }

    public void skipRemainingSiblings() {
        this.skipRemainingSiblings = true;
        this.traverse = false;
    }

    public void dontGoDeeper() {
        this.traverse = false;
    }

    @Override
    public final Iterator<I> iterator() {
        return this;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder(500);
        msg.append("traverse=").append(this.traverse).append("; childFirst=").append(this.childFirst).append("; hasNextWasLast=").append(this.hasNextWasLast).append("\n");
        msg.append("data.node=").append(((LevelIterator)this.data).node).append("\n").append("data.lastNode=").append(((LevelIterator)this.data).lastNode).append("\n");
        msg.append("stack.size=").append(this.stack.size());
        return msg.toString();
    }

    private static class LevelIterator<N>
    implements Iterator<N> {
        private final N node;
        private final Iterator<N> iter;
        private N lastNode;

        public LevelIterator(N node, Iterator<N> iter) {
            Args.notNull(iter, (String)"iter");
            this.node = node;
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public N next() {
            this.lastNode = this.iter.next();
            return this.lastNode;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        public String toString() {
            StringBuilder msg = new StringBuilder(500);
            msg.append("node=").append(this.node).append("\n").append("lastNode=").append(this.lastNode).append("\n");
            return msg.toString();
        }
    }
}

