/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static String readString(IResourceStream resourceStream) {
        return ResourceUtil.readString(resourceStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(IResourceStream resourceStream, Charset charset) {
        String string;
        InputStream stream = resourceStream.getInputStream();
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            string = new String(bytes, charset.name());
        }
        catch (Throwable throwable) {
            try {
                resourceStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new WicketRuntimeException("failed to read string from " + resourceStream, e);
            }
            catch (ResourceStreamNotFoundException e) {
                throw new WicketRuntimeException("failed to locate stream from " + resourceStream, e);
            }
        }
        resourceStream.close();
        return string;
    }
}

