/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class CssContentHeaderItem
extends CssHeaderItem {
    private final CharSequence css;
    private final String id;

    public CssContentHeaderItem(CharSequence css, String id, String condition) {
        super(condition);
        this.css = css;
        this.id = id;
    }

    public CharSequence getCss() {
        return this.css;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void render(Response response) {
        boolean hasCondition;
        boolean bl = hasCondition = !Strings.isEmpty((CharSequence)this.getCondition());
        if (hasCondition) {
            response.write((CharSequence)"<!--[if ");
            response.write((CharSequence)this.getCondition());
            response.write((CharSequence)"]>");
        }
        CssUtils.writeCss(response, this.getCss(), this.getId());
        if (hasCondition) {
            response.write((CharSequence)"<![endif]-->\n");
        }
    }

    @Override
    public Iterable<?> getRenderTokens() {
        if (Strings.isEmpty((CharSequence)this.getId())) {
            return Collections.singletonList(this.getCss());
        }
        return Arrays.asList(this.getId(), this.getCss());
    }

    public String toString() {
        return "CSSHeaderItem(" + this.getCss() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssContentHeaderItem that = (CssContentHeaderItem)o;
        if (this.css != null ? !this.css.equals(that.css) : that.css != null) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        int result = this.css != null ? this.css.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }
}

