/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.inspector;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.debug.PageView;
import org.apache.wicket.util.lang.Classes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderPerformanceListener
implements IComponentInstantiationListener {
    private static final Logger log = LoggerFactory.getLogger(RenderPerformanceListener.class);

    public void onInstantiation(Component component) {
        if (this.accepts(component)) {
            component.add(new Behavior[]{new RenderMeasuringBehavior()});
        }
    }

    protected boolean accepts(Component component) {
        return !component.isAuto();
    }

    private static class RenderMeasuringBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        private RenderMeasuringBehavior() {
        }

        public void beforeRender(Component component) {
            super.beforeRender(component);
            if (!component.isAuto()) {
                Long now = System.currentTimeMillis();
                component.setMetaData(PageView.RENDER_KEY, (Object)now);
            }
        }

        public void afterRender(Component component) {
            super.afterRender(component);
            Long renderEnd = System.currentTimeMillis();
            Long renderStart = (Long)component.getMetaData(PageView.RENDER_KEY);
            if (renderStart != null && !component.isAuto()) {
                Long duration = renderEnd - renderStart;
                component.setMetaData(PageView.RENDER_KEY, (Object)duration);
                if (log.isDebugEnabled()) {
                    String componentPath = component instanceof Page ? Classes.simpleName(component.getClass()) + " page" : component.getPageRelativePath();
                    log.debug("rendered '{}' for {}ms", (Object)componentPath, (Object)duration);
                }
            }
        }
    }
}

