package org.apache.dvsl;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.List;
import java.util.Map;


/**
 *  wrapper interface for nodes exposed in the
 *  template.  Isolates the in-VSL DOM from that
 *  of the underlying implementation
 *
 *  @author <a href="mailto:geirm@apache.org">Geir Magnusson Jr.</a>
 */
public interface DVSLNode
{
    /**
     *  returns the name of the node
     */
    public String name();

    /**
     *  returns the 'value' of the node
     */
    public String value();

    /**
     *  returns the value of the XPAth
     *  expression
     */
    public Object valueOf( String xpath );

    /**
     *  returns attribute
     */
    public String attrib( String attribute );

    /**
     *  returns a list of nodes that satisfy
     *  the xpath
     */
    public List selectNodes( String xpath );

    /**
     *  returns a single node that satisfies
     *  the xpath
     */
    public DVSLNode selectSingleNode( String xpath );
    public DVSLNode get( String xpath );

    /**
     *  renders a deep copy of the XML tree
     *  below the current node to the output
     */
    public String copy();

    /**
     *  renders a deep copy of the nodes in
     *  the list ot the output
     */
    public String copy( List nodeList );

    /**
     *  returns a list of all children of the current
     *  node
     */
    public List children();


    /**
     *  returns the 'value' of the node
     */
    public String toString();


    /* ====================== */

    /**
     *  returns the object corresponding to the node
     *  in the implementaion that we are using.
     *  use only with the greatest of care
     */

    Object getNodeImpl();

    Map getAttribMap();
}

