/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiScopedServletContext
implements ServletContext {
    private final OsgiServletContext osgiContext;
    private final Bundle bundle;
    private final WebContainerContext webContainerContext;

    public OsgiScopedServletContext(OsgiServletContext osgiContext, Bundle bundle) {
        this.osgiContext = osgiContext;
        this.bundle = bundle;
        this.webContainerContext = osgiContext.getOsgiContextModel().resolveHttpContext(bundle);
    }

    public WebContainerContext getResolvedWebContainerContext() {
        return this.webContainerContext;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void releaseWebContainerContext(Bundle bundle) {
        this.osgiContext.getOsgiContextModel().releaseHttpContext(bundle);
    }

    public OsgiServletContext getOsgiContext() {
        return this.osgiContext;
    }

    public OsgiContextModel getOsgiContextModel() {
        return this.osgiContext.getOsgiContextModel();
    }

    public ServletContext getContainerServletContext() {
        return this.osgiContext.getContainerServletContext();
    }

    public ClassLoader getOsgiContextClassLoader() {
        return this.osgiContext.getClassLoader();
    }

    public String[] getWelcomeFiles() {
        return this.osgiContext.getWelcomeFiles();
    }

    public boolean isWelcomeFilesRedirect() {
        return this.osgiContext.isWelcomeFilesRedirect();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException("addFilter() is not supported.");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException("addFilter() is not supported.");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new UnsupportedOperationException("addFilter() is not supported.");
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException("addListener() is not supported.");
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException("addListener() is not supported.");
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException("addListener() is not supported.");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException("addServlet() is not supported.");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException("addServlet() is not supported.");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException("addServlet() is not supported.");
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("createFilter() is not supported.");
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("createListener() is not supported.");
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("createServlet() is not supported.");
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException("declareRoles() is not supported.");
    }

    public boolean setInitParameter(String name, String value) {
        throw new UnsupportedOperationException("setInitParameter() is not supported.");
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException("setSessionTrackingModes() is not supported.");
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        throw new UnsupportedOperationException("addJspFile() is not supported.");
    }

    public Object getAttribute(String name) {
        return this.osgiContext.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.osgiContext.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.osgiContext.setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        this.osgiContext.removeAttribute(name);
    }

    public String getContextPath() {
        return this.osgiContext.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return this.osgiContext.getContext(uripath);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.osgiContext.getDefaultSessionTrackingModes();
    }

    public int getEffectiveMajorVersion() {
        return this.osgiContext.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.osgiContext.getEffectiveMinorVersion();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.osgiContext.getEffectiveSessionTrackingModes();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.osgiContext.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.osgiContext.getFilterRegistrations();
    }

    public int getMajorVersion() {
        return this.osgiContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.osgiContext.getMinorVersion();
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.osgiContext.getServlet(name);
    }

    public Enumeration<String> getServletNames() {
        return this.osgiContext.getServletNames();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.osgiContext.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.osgiContext.getServletRegistrations();
    }

    public Enumeration<Servlet> getServlets() {
        return this.osgiContext.getServlets();
    }

    public String getVirtualServerName() {
        return this.osgiContext.getVirtualServerName();
    }

    public String getServerInfo() {
        return this.osgiContext.getServerInfo();
    }

    public void log(String msg) {
        this.osgiContext.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.osgiContext.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.osgiContext.log(message, throwable);
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.osgiContext.getSessionCookieConfig();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.osgiContext.getJspConfigDescriptor();
    }

    public int getSessionTimeout() {
        return this.osgiContext.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.osgiContext.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.osgiContext.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.osgiContext.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.osgiContext.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.osgiContext.setResponseCharacterEncoding(encoding);
    }

    public String getMimeType(String file) {
        return this.osgiContext.getMimeType(this.webContainerContext, file);
    }

    public String getRealPath(String path) {
        return this.osgiContext.getRealPath(this.webContainerContext, path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.osgiContext.getResource(this.webContainerContext, path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.osgiContext.getResourceAsStream(this.webContainerContext, path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.osgiContext.getResourcePaths(this.webContainerContext, path);
    }

    public String getInitParameter(String name) {
        return this.osgiContext.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.osgiContext.getInitParameterNames();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.osgiContext.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.osgiContext.getNamedDispatcher(name);
    }

    public String getServletContextName() {
        return this.osgiContext.getServletContextName();
    }

    public ClassLoader getClassLoader() {
        if (this.getOsgiContextModel().isWab()) {
            return this.getOsgiContextModel().getClassLoader();
        }
        return ((BundleWiring)this.bundle.adapt(BundleWiring.class)).getClassLoader();
    }
}

