/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.mail.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;

public class SendMailAction
implements ActionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SendMailAction.class.getName());
    private PersistenceService persistenceService;
    private String mailServerHostName;
    private int mailServerPort;
    private String mailServerUsername;
    private String mailServerPassword;
    private boolean mailServerSSLOnConnect = true;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setMailServerHostName(String mailServerHostName) {
        this.mailServerHostName = mailServerHostName;
    }

    public void setMailServerPort(int mailServerPort) {
        this.mailServerPort = mailServerPort;
    }

    public void setMailServerUsername(String mailServerUsername) {
        this.mailServerUsername = mailServerUsername;
    }

    public void setMailServerPassword(String mailServerPassword) {
        this.mailServerPassword = mailServerPassword;
    }

    public void setMailServerSSLOnConnect(boolean mailServerSSLOnConnect) {
        this.mailServerSSLOnConnect = mailServerSSLOnConnect;
    }

    public int execute(Action action, Event event) {
        HashMap profileNotif;
        String notifType = (String)action.getParameterValues().get("notificationType");
        String notifTypeId = (String)action.getParameterValues().get("notificationTypeId");
        Boolean notifyOnce = (Boolean)action.getParameterValues().get("notifyOncePerProfile");
        String from = (String)action.getParameterValues().get("from");
        String to = (String)action.getParameterValues().get("to");
        String cc = (String)action.getParameterValues().get("cc");
        String bcc = (String)action.getParameterValues().get("bcc");
        String subject = (String)action.getParameterValues().get("subject");
        String template = (String)action.getParameterValues().get("template");
        if (notifType == null) {
            notifType = "default";
        }
        if (notifTypeId == null) {
            notifTypeId = subject;
        }
        if (notifyOnce == null) {
            notifyOnce = false;
        }
        if ((profileNotif = (HashMap)event.getProfile().getSystemProperties().get("notificationAck")) != null && profileNotif.get(notifType) != null && ((HashMap)profileNotif.get(notifType)).get(notifTypeId) != null) {
            notifTypeAck = (Integer)((HashMap)profileNotif.get(notifType)).get(notifTypeId);
            if (notifyOnce.booleanValue() && notifTypeAck > 0) {
                LOGGER.info("Notification {} already sent for the profile {}", (Object)notifType, (Object)event.getProfileId());
                return 0;
            }
            ((HashMap)profileNotif.get(notifType)).put(notifTypeId, notifTypeAck + 1);
        } else {
            if (profileNotif == null) {
                profileNotif = new HashMap();
            }
            profileNotif.put(notifType, profileNotif.get(notifType) != null ? profileNotif.get(notifType) : new HashMap());
            notifTypeAck = (Integer)((HashMap)profileNotif.get(notifType)).get(notifTypeId);
            if (notifTypeAck == null) {
                ((HashMap)profileNotif.get(notifType)).put(notifTypeId, 1);
            }
        }
        event.getProfile().setSystemProperty("notificationAck", profileNotif);
        event.getProfile().setSystemProperty("lastUpdated", (Object)new Date());
        this.persistenceService.update((Item)event.getProfile(), Profile.class, "systemProperties", (Object)event.getProfile().getSystemProperties());
        ST stringTemplate = new ST(template, '$', '$');
        stringTemplate.add("profile", (Object)event.getProfile());
        stringTemplate.add("event", (Object)event);
        String htmlEmailTemplate = stringTemplate.render();
        try {
            new URL("http://www.apache.org");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        ImageHtmlEmail email = new ImageHtmlEmail();
        email.setHostName(this.mailServerHostName);
        email.setSmtpPort(this.mailServerPort);
        email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.mailServerUsername, this.mailServerPassword));
        email.setSSLOnConnect(this.mailServerSSLOnConnect);
        try {
            email.addTo(to);
            email.setFrom(from);
            if (cc != null && cc.length() > 0) {
                email.addCc(cc);
            }
            if (bcc != null && bcc.length() > 0) {
                email.addBcc(bcc);
            }
            email.setSubject(subject);
            email.setHtmlMsg(htmlEmailTemplate);
            email.setTextMsg("Your email client does not support HTML messages");
            email.send();
        }
        catch (EmailException e) {
            LOGGER.error("Cannot send mail", (Throwable)e);
        }
        return 0;
    }
}

