/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SemanticQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final String query;
    public static final JsonpDeserializer<SemanticQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SemanticQuery::setupSemanticQueryDeserializer);

    private SemanticQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static SemanticQuery of(Function<Builder, ObjectBuilder<SemanticQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Semantic;
    }

    public final String field() {
        return this.field;
    }

    public final String query() {
        return this.query;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("query");
        generator.write(this.query);
    }

    protected static void setupSemanticQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SemanticQuery> {
        private String field;
        private String query;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SemanticQuery build() {
            this._checkSingleUse();
            return new SemanticQuery(this);
        }
    }
}

