/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.core.search.InnerHits;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HasParentQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final InnerHits innerHits;
    private final String parentType;
    private final Query query;
    @Nullable
    private final Boolean score;
    public static final JsonpDeserializer<HasParentQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HasParentQuery::setupHasParentQueryDeserializer);

    private HasParentQuery(Builder builder) {
        super(builder);
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.innerHits = builder.innerHits;
        this.parentType = ApiTypeHelper.requireNonNull(builder.parentType, this, "parentType");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.score = builder.score;
    }

    public static HasParentQuery of(Function<Builder, ObjectBuilder<HasParentQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.HasParent;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public final InnerHits innerHits() {
        return this.innerHits;
    }

    public final String parentType() {
        return this.parentType;
    }

    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Boolean score() {
        return this.score;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.innerHits != null) {
            generator.writeKey("inner_hits");
            this.innerHits.serialize(generator, mapper);
        }
        generator.writeKey("parent_type");
        generator.write(this.parentType);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.score != null) {
            generator.writeKey("score");
            generator.write(this.score.booleanValue());
        }
    }

    protected static void setupHasParentQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(Builder::innerHits, InnerHits._DESERIALIZER, "inner_hits");
        op.add(Builder::parentType, JsonpDeserializer.stringDeserializer(), "parent_type");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::score, JsonpDeserializer.booleanDeserializer(), "score");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HasParentQuery> {
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private InnerHits innerHits;
        private String parentType;
        private Query query;
        @Nullable
        private Boolean score;

        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        public final Builder innerHits(@Nullable InnerHits value) {
            this.innerHits = value;
            return this;
        }

        public final Builder innerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.innerHits(fn.apply(new InnerHits.Builder()).build());
        }

        public final Builder parentType(String value) {
            this.parentType = value;
            return this;
        }

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder query(QueryVariant value) {
            this.query = value._toQuery();
            return this;
        }

        public final Builder score(@Nullable Boolean value) {
            this.score = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HasParentQuery build() {
            this._checkSingleUse();
            return new HasParentQuery(this);
        }
    }
}

