/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ClusterDetails;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterStatistics
implements JsonpSerializable {
    private final int skipped;
    private final int successful;
    private final int total;
    private final int running;
    private final int partial;
    private final int failed;
    private final Map<String, ClusterDetails> details;
    public static final JsonpDeserializer<ClusterStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterStatistics::setupClusterStatisticsDeserializer);

    private ClusterStatistics(Builder builder) {
        this.skipped = ApiTypeHelper.requireNonNull(builder.skipped, (Object)this, "skipped", 0);
        this.successful = ApiTypeHelper.requireNonNull(builder.successful, (Object)this, "successful", 0);
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0);
        this.running = ApiTypeHelper.requireNonNull(builder.running, (Object)this, "running", 0);
        this.partial = ApiTypeHelper.requireNonNull(builder.partial, (Object)this, "partial", 0);
        this.failed = ApiTypeHelper.requireNonNull(builder.failed, (Object)this, "failed", 0);
        this.details = ApiTypeHelper.unmodifiable(builder.details);
    }

    public static ClusterStatistics of(Function<Builder, ObjectBuilder<ClusterStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int skipped() {
        return this.skipped;
    }

    public final int successful() {
        return this.successful;
    }

    public final int total() {
        return this.total;
    }

    public final int running() {
        return this.running;
    }

    public final int partial() {
        return this.partial;
    }

    public final int failed() {
        return this.failed;
    }

    public final Map<String, ClusterDetails> details() {
        return this.details;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("skipped");
        generator.write(this.skipped);
        generator.writeKey("successful");
        generator.write(this.successful);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("running");
        generator.write(this.running);
        generator.writeKey("partial");
        generator.write(this.partial);
        generator.writeKey("failed");
        generator.write(this.failed);
        if (ApiTypeHelper.isDefined(this.details)) {
            generator.writeKey("details");
            generator.writeStartObject();
            for (Map.Entry<String, ClusterDetails> item0 : this.details.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupClusterStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::skipped, JsonpDeserializer.integerDeserializer(), "skipped");
        op.add(Builder::successful, JsonpDeserializer.integerDeserializer(), "successful");
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::running, JsonpDeserializer.integerDeserializer(), "running");
        op.add(Builder::partial, JsonpDeserializer.integerDeserializer(), "partial");
        op.add(Builder::failed, JsonpDeserializer.integerDeserializer(), "failed");
        op.add(Builder::details, JsonpDeserializer.stringMapDeserializer(ClusterDetails._DESERIALIZER), "details");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterStatistics> {
        private Integer skipped;
        private Integer successful;
        private Integer total;
        private Integer running;
        private Integer partial;
        private Integer failed;
        @Nullable
        private Map<String, ClusterDetails> details;

        public final Builder skipped(int value) {
            this.skipped = value;
            return this;
        }

        public final Builder successful(int value) {
            this.successful = value;
            return this;
        }

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder running(int value) {
            this.running = value;
            return this;
        }

        public final Builder partial(int value) {
            this.partial = value;
            return this;
        }

        public final Builder failed(int value) {
            this.failed = value;
            return this;
        }

        public final Builder details(Map<String, ClusterDetails> map) {
            this.details = Builder._mapPutAll(this.details, map);
            return this;
        }

        public final Builder details(String key, ClusterDetails value) {
            this.details = Builder._mapPut(this.details, key, value);
            return this;
        }

        public final Builder details(String key, Function<ClusterDetails.Builder, ObjectBuilder<ClusterDetails>> fn) {
            return this.details(key, fn.apply(new ClusterDetails.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterStatistics build() {
            this._checkSingleUse();
            return new ClusterStatistics(this);
        }
    }
}

