/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch.querybuilders.advanced;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilderDispatcher;

public class GeoLocationByPointSessionConditionESQueryBuilder
implements ConditionESQueryBuilder {
    public Query buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        String name;
        String type = (String)condition.getParameter("type");
        String string = name = condition.getParameter("name") == null ? "location" : (String)condition.getParameter("name");
        if ("circle".equals(type)) {
            Double circleLatitude = ((Number)condition.getParameter("circleLatitude")).doubleValue();
            Double circleLongitude = ((Number)condition.getParameter("circleLongitude")).doubleValue();
            String distance = condition.getParameter("distance").toString();
            if (circleLatitude != null && circleLongitude != null && distance != null) {
                return Query.of(q -> q.geoDistance(g -> g.field(name).location(l -> l.latlon(latlong -> latlong.lat(circleLatitude.doubleValue()).lon(circleLongitude.doubleValue()))).distance(distance)));
            }
        } else if ("rectangle".equals(type)) {
            Double rectLatitudeNE = (Double)condition.getParameter("rectLatitudeNE");
            Double rectLongitudeNE = (Double)condition.getParameter("rectLongitudeNE");
            Double rectLatitudeSW = (Double)condition.getParameter("rectLatitudeSW");
            Double rectLongitudeSW = (Double)condition.getParameter("rectLongitudeSW");
            if (rectLatitudeNE != null && rectLongitudeNE != null && rectLatitudeSW != null && rectLongitudeSW != null) {
                return Query.of(q -> q.geoBoundingBox(g -> g.field(name).boundingBox(b -> b.coords(c -> c.top(rectLatitudeNE.doubleValue()).left(rectLongitudeNE.doubleValue()).bottom(rectLatitudeSW.doubleValue()).right(rectLongitudeSW.doubleValue())))));
            }
        }
        return null;
    }
}

