/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.campaigns.Campaign;
import org.apache.unomi.api.campaigns.CampaignDetail;
import org.apache.unomi.api.campaigns.events.CampaignEvent;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.GoalsService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/campaigns")
@Component(service={CampaignsServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class CampaignsServiceEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CampaignsServiceEndPoint.class.getName());
    @Reference
    private GoalsService goalsService;

    public CampaignsServiceEndPoint() {
        LOGGER.info("Initializing campaigns service endpoint...");
    }

    public void setGoalsService(GoalsService goalsService) {
        this.goalsService = goalsService;
    }

    @GET
    @Path(value="/")
    public Set<Metadata> getCampaignMetadatas() {
        return this.goalsService.getCampaignMetadatas();
    }

    @POST
    @Path(value="/")
    public void setCampaignDefinition(Campaign campaign) {
        this.goalsService.setCampaign(campaign);
    }

    @POST
    @Path(value="/query")
    public Set<Metadata> getCampaignMetadatas(Query query) {
        return this.goalsService.getCampaignMetadatas(query);
    }

    @POST
    @Path(value="/query/detailed")
    public PartialList<CampaignDetail> getCampaignDetails(Query query) {
        return this.goalsService.getCampaignDetails(query);
    }

    @GET
    @Path(value="/{campaignID}/detailed")
    public CampaignDetail getCampaignDetail(@PathParam(value="campaignID") String campaignID) {
        return this.goalsService.getCampaignDetail(campaignID);
    }

    @GET
    @Path(value="/{campaignID}")
    public Campaign getCampaignDefinition(@PathParam(value="campaignID") String campaignID) {
        return this.goalsService.getCampaign(campaignID);
    }

    @DELETE
    @Path(value="/{campaignID}")
    public void removeCampaignDefinition(@PathParam(value="campaignID") String campaignID) {
        this.goalsService.removeCampaign(campaignID);
    }

    @POST
    @Path(value="/event")
    public void setCampaignEventDefinition(CampaignEvent campaignEvent) {
        this.goalsService.setCampaignEvent(campaignEvent);
    }

    @DELETE
    @Path(value="/event/{eventId}")
    public void removeCampaignEventDefinition(@PathParam(value="eventId") String campaignEventID) {
        this.goalsService.removeCampaignEvent(campaignEventID);
    }

    @POST
    @Path(value="/events/query")
    public PartialList<CampaignEvent> getCampaignEvents(Query query) {
        return this.goalsService.getEvents(query);
    }
}

