/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;

public class BoundedOutputStreamWriter
extends Writer {
    private final Writer delegate;

    public BoundedOutputStreamWriter(OutputStream outputStream, Charset charset, int maxSize) {
        this.delegate = Channels.newWriter(Channels.newChannel(outputStream), charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), maxSize);
    }

    @Override
    public void write(int c) throws IOException {
        this.delegate.write(c);
    }

    @Override
    public void write(char[] chars, int off, int len) throws IOException {
        this.delegate.write(chars, off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.delegate.write(str, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.delegate.write(cbuf);
    }

    @Override
    public void write(String str) throws IOException {
        this.delegate.write(str);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.delegate.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.delegate.append(csq, start, end);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.delegate.append(c);
    }
}

