/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.core.osgi.OsgiNamingHelper;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.osgi.framework.BundleContext;

public class OsgiCamelContextNameStrategy
implements CamelContextNameStrategy {
    private static final AtomicInteger CONTEXT_COUNTER = new AtomicInteger(0);
    private final BundleContext context;
    private final String prefix = "camel";
    private volatile String name;

    public OsgiCamelContextNameStrategy(BundleContext context) {
        this.context = context;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getNextName();
        }
        return this.name;
    }

    public synchronized String getNextName() {
        return OsgiNamingHelper.findFreeCamelContextName(this.context, "camel", "camel.context.name", CONTEXT_COUNTER, false);
    }

    public boolean isFixedName() {
        return false;
    }
}

