/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.util.ArrayList;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.common.DataTable;
import org.apache.unomi.shell.commands.ListCommandSupport;

@Command(scope="unomi", name="event-list", description="This commands lists the latest events updated in the Apache Unomi Context Server")
@Service
public class EventList
extends ListCommandSupport {
    @Reference
    private EventService eventService;
    @Reference
    DefinitionsService definitionsService;
    @Argument(index=0, name="maxEntries", description="The maximum number of entries to retrieve (defaults to 100)", required=false, multiValued=false)
    int maxEntries = 100;
    @Argument(index=1, name="eventType", description="If specified, will filter the event list by the given event type", required=false, multiValued=false)
    String eventType = null;
    String[] columnHeaders = new String[]{"ID", "Type", "Session", "Profile", "Timestamp", "Scope", "Persistent"};

    @Override
    protected String[] getHeaders() {
        return this.columnHeaders;
    }

    @Override
    protected DataTable buildDataTable() {
        Condition condition = new Condition(this.definitionsService.getConditionType("matchAllCondition"));
        if (this.eventType != null) {
            condition = new Condition(this.definitionsService.getConditionType("eventTypeCondition"));
            condition.setParameter("eventTypeId", (Object)this.eventType);
        }
        Query query = new Query();
        query.setLimit(this.maxEntries);
        query.setCondition(condition);
        query.setSortby("timeStamp:desc");
        PartialList lastEvents = this.eventService.search(query);
        DataTable dataTable = new DataTable();
        for (Event event : lastEvents.getList()) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(event.getItemId());
            rowData.add(event.getEventType());
            rowData.add(event.getSessionId());
            rowData.add(event.getProfileId());
            rowData.add(event.getTimeStamp().toString());
            rowData.add(event.getScope());
            rowData.add(Boolean.toString(event.isPersistent()));
            dataTable.addRow(rowData.toArray(new Comparable[rowData.size()]));
        }
        return dataTable;
    }
}

