/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.ssl.Java13;
import org.apache.commons.ssl.Java14;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.TrustChain;

public abstract class JavaImpl {
    private static JavaImpl HANDLER;

    public static void downgrade() {
        if (HANDLER instanceof Java14) {
            HANDLER = Java13.getInstance();
        }
    }

    public static boolean isJava13() {
        return HANDLER instanceof Java13;
    }

    public static void uprade() {
        if (HANDLER instanceof Java13) {
            HANDLER = Java14.getInstance();
        }
    }

    public abstract String getVersion();

    protected abstract Object buildKeyManagerFactory(KeyStore var1, char[] var2) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException;

    protected abstract Object[] retrieveKeyManagers(Object var1);

    protected abstract Object buildTrustManagerFactory(KeyStore var1) throws NoSuchAlgorithmException, KeyStoreException;

    protected abstract Object[] retrieveTrustManagers(Object var1);

    protected abstract String retrieveSubjectX500(X509Certificate var1);

    protected abstract String retrieveIssuerX500(X509Certificate var1);

    protected abstract Certificate[] retrievePeerCerts(SSLSession var1) throws SSLPeerUnverifiedException;

    protected abstract SSLSocketFactory buildSSLSocketFactory(Object var1);

    protected abstract SSLServerSocketFactory buildSSLServerSocketFactory(Object var1);

    protected abstract SSLSocket buildSocket(SSL var1) throws IOException;

    protected abstract SSLSocket buildSocket(SSL var1, String var2, int var3, InetAddress var4, int var5, int var6) throws IOException;

    protected abstract Socket buildPlainSocket(SSL var1, String var2, int var3, InetAddress var4, int var5, int var6) throws IOException;

    protected abstract Socket connectSocket(Socket var1, SocketFactory var2, String var3, int var4, InetAddress var5, int var6, int var7, SSL var8) throws IOException;

    protected abstract SSLServerSocket buildServerSocket(SSL var1) throws IOException;

    protected abstract void wantClientAuth(Object var1, boolean var2);

    protected abstract void enabledProtocols(Object var1, String[] var2);

    protected abstract RuntimeException buildRuntimeException(Exception var1);

    protected abstract Object initSSL(SSL var1, TrustChain var2, KeyMaterial var3) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, KeyManagementException, IOException;

    protected abstract void checkTrusted(Object var1, X509Certificate[] var2, String var3) throws CertificateException;

    public static Object init(SSL ssl, TrustChain trustChain, KeyMaterial keyMaterial) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, KeyManagementException, IOException {
        return HANDLER.initSSL(ssl, trustChain, keyMaterial);
    }

    public static RuntimeException newRuntimeException(Exception cause) {
        return HANDLER.buildRuntimeException(cause);
    }

    public static SSLSocketFactory getSSLSocketFactory(Object sslContext) {
        return HANDLER.buildSSLSocketFactory(sslContext);
    }

    public static SSLServerSocketFactory getSSLServerSocketFactory(Object sslContext) {
        return HANDLER.buildSSLServerSocketFactory(sslContext);
    }

    public static String getSubjectX500(X509Certificate cert) {
        return HANDLER.retrieveSubjectX500(cert);
    }

    public static String getIssuerX500(X509Certificate cert) {
        return HANDLER.retrieveIssuerX500(cert);
    }

    public static Object newKeyManagerFactory(KeyStore ks, char[] password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        return HANDLER.buildKeyManagerFactory(ks, password);
    }

    public static Object[] getKeyManagers(Object keyManagerFactory) {
        return HANDLER.retrieveKeyManagers(keyManagerFactory);
    }

    public static Object newTrustManagerFactory(KeyStore ks) throws NoSuchAlgorithmException, KeyStoreException {
        return HANDLER.buildTrustManagerFactory(ks);
    }

    public static Object[] getTrustManagers(Object trustManagerFactory) {
        return HANDLER.retrieveTrustManagers(trustManagerFactory);
    }

    public static SSLSocket createSocket(SSL ssl) throws IOException {
        return HANDLER.buildSocket(ssl);
    }

    public static SSLSocket createSocket(SSL ssl, String remoteHost, int remotePort, InetAddress localHost, int localPort, int connectTimeout) throws IOException {
        return HANDLER.buildSocket(ssl, remoteHost, remotePort, localHost, localPort, connectTimeout);
    }

    public static Socket createPlainSocket(SSL ssl, String remoteHost, int remotePort, InetAddress localHost, int localPort, int connectTimeout) throws IOException {
        return HANDLER.buildPlainSocket(ssl, remoteHost, remotePort, localHost, localPort, connectTimeout);
    }

    protected static Socket connect(Socket s, SocketFactory sf, String remoteHost, int remotePort, InetAddress localHost, int localPort, int timeout, SSL ssl) throws IOException {
        return HANDLER.connectSocket(s, sf, remoteHost, remotePort, localHost, localPort, timeout, ssl);
    }

    public static SSLServerSocket createServerSocket(SSL ssl) throws IOException {
        return HANDLER.buildServerSocket(ssl);
    }

    public static void setWantClientAuth(Object o, boolean wantClientAuth) {
        HANDLER.wantClientAuth(o, wantClientAuth);
    }

    public static void setEnabledProtocols(Object o, String[] enabledProtocols) {
        HANDLER.enabledProtocols(o, enabledProtocols);
    }

    public static Certificate[] getPeerCertificates(SSLSession session) throws SSLPeerUnverifiedException {
        return HANDLER.retrievePeerCerts(session);
    }

    public static void testTrust(Object trustManager, X509Certificate[] chain, String authType) throws CertificateException {
        HANDLER.checkTrusted(trustManager, chain, authType);
    }

    public static void load() {
        HANDLER.hashCode();
    }

    static {
        JavaImpl h = null;
        try {
            h = Java14.getInstance();
        }
        catch (Throwable t) {
            System.out.println("commons-ssl reverting to: Java 1.3 + jsse.jar");
        }
        if (h == null) {
            h = Java13.getInstance();
        }
        HANDLER = h;
    }
}

