/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.zip;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.TimeZone;
import java.util.zip.ZipEntry;

public class ZipUtil {
    private static final TimeZone tz = TimeZone.getDefault();

    public static long getModifiedTime(ZipEntry entry) {
        long time = entry.getTime();
        time += (long)tz.getOffset(time);
        return Math.min(time, System.currentTimeMillis() - 1L);
    }

    public static void setModifiedTime(ZipEntry entry, long utc) {
        utc -= (long)tz.getOffset(utc);
        entry.setTime(utc);
    }

    public static String cleanPath(String path) {
        StringBuilder out = new StringBuilder();
        int length = Objects.requireNonNull(path).length();
        State state = State.begin;
        int level = 0;
        block20: for (int i = length - 1; i >= 0; --i) {
            char c = path.charAt(i);
            switch (state) {
                case begin: {
                    switch (c) {
                        case '/': {
                            if (i != length - 1) continue block20;
                            out.append('/');
                            continue block20;
                        }
                        case '.': {
                            state = State.one;
                            continue block20;
                        }
                    }
                    state = State.segment;
                    if (level < 0) continue block20;
                    out.append(c);
                    continue block20;
                }
                case one: {
                    switch (c) {
                        case '/': {
                            state = State.begin;
                            continue block20;
                        }
                        case '.': {
                            state = State.two;
                            continue block20;
                        }
                    }
                    state = State.segment;
                    if (level < 0) continue block20;
                    out.append('.').append(c);
                    continue block20;
                }
                case two: {
                    switch (c) {
                        case '/': {
                            state = State.begin;
                            --level;
                            continue block20;
                        }
                    }
                    state = State.segment;
                    if (level < 0) continue block20;
                    out.append('.').append('.').append(c);
                    continue block20;
                }
                case segment: {
                    switch (c) {
                        case '/': {
                            state = State.begin;
                            if (level >= 0) break;
                            ++level;
                            continue block20;
                        }
                    }
                    if (level < 0) continue block20;
                    out.append(c);
                }
            }
        }
        int last = out.length() - 1;
        if (last > 0 && out.charAt(last) == '/') {
            out.setLength(last);
        }
        if (out.length() == length) {
            return path;
        }
        if (state == State.one && level == -1 || state == State.two || level < -1) {
            throw new UncheckedIOException(new IOException("Entry path is outside of zip file: " + path));
        }
        return out.reverse().toString();
    }

    public static boolean isCompromised(String path) {
        try {
            ZipUtil.cleanPath(path);
            return false;
        }
        catch (UncheckedIOException e) {
            return true;
        }
    }

    static enum State {
        begin,
        one,
        two,
        segment;

    }
}

