/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.cellar.core.Dispatcher;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventConsumer;
import org.apache.karaf.cellar.core.utils.CombinedClassLoader;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueConsumer<E extends Event>
implements EventConsumer<E>,
ItemListener<E>,
Runnable {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(QueueConsumer.class);
    public static final String SWITCH_ID = "org.apache.karaf.cellar.queue.consumer";
    private final Switch eventSwitch = new BasicSwitch("org.apache.karaf.cellar.queue.consumer");
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Boolean isConsuming = Boolean.TRUE;
    private String registrationId;
    private HazelcastInstance instance;
    private IQueue queue;
    private Dispatcher dispatcher;
    private Node node;
    private CombinedClassLoader combinedClassLoader;
    private ConfigurationAdmin configurationAdmin;

    public QueueConsumer() {
    }

    public QueueConsumer(CombinedClassLoader combinedClassLoader) {
        this.combinedClassLoader = combinedClassLoader;
    }

    public void init() {
        if (this.queue != null) {
            this.registrationId = this.queue.addItemListener((ItemListener)this, true);
        } else {
            this.queue = this.instance.getQueue("org.apache.karaf.cellar.event.queue");
            this.registrationId = this.queue.addItemListener((ItemListener)this, true);
        }
        this.executorService.execute(this);
    }

    public void destroy() {
        this.isConsuming = false;
        if (this.queue != null) {
            this.queue.removeItemListener(this.registrationId);
        }
        this.executorService.shutdown();
    }

    @Override
    public void run() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        while (this.isConsuming.booleanValue()) {
            if (this.combinedClassLoader != null) {
                Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            } else {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            Event e = null;
            try {
                e = (Event)this.getQueue().poll(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                LOGGER.warn("CELLAR HAZELCAST: consume task interrupted");
            }
            catch (Exception e2) {
                LOGGER.warn("CELLAR HAZELCAST: consumer task failed to poll the queue", (Throwable)e2);
            }
            try {
                if (e == null) continue;
                this.consume(e);
            }
            catch (HazelcastInstanceNotActiveException hex) {
                LOGGER.debug("CELLAR HAZELCAST: instance not active, stop consuming", (Throwable)hex);
                break;
            }
            catch (Exception e1) {
                LOGGER.error("CELLAR HAZELCAST: failed to consume from queue", (Throwable)e1);
            }
        }
        Thread.currentThread().setContextClassLoader(originalClassLoader);
    }

    public void consume(E event) {
        if (event != null && (this.getSwitch().getStatus().equals((Object)SwitchStatus.ON) || event.getForce().booleanValue())) {
            this.dispatcher.dispatch(event);
        } else if (this.eventSwitch.getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.debug("CELLAR HAZELCAST: {} switch is OFF, cluster event is not consumed", (Object)SWITCH_ID);
        }
    }

    public void start() {
        this.isConsuming = true;
        this.executorService.execute(this);
    }

    public void stop() {
        this.isConsuming = false;
    }

    public Boolean isConsuming() {
        return this.isConsuming;
    }

    public void itemAdded(ItemEvent<E> event) {
    }

    public void itemRemoved(ItemEvent<E> event) {
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public HazelcastInstance getInstance() {
        return this.instance;
    }

    public void setInstance(HazelcastInstance instance) {
        this.instance = instance;
    }

    public IQueue<E> getQueue() {
        return this.queue;
    }

    public void setQueue(IQueue<E> queue) {
        this.queue = queue;
    }

    public Switch getSwitch() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null) {
                Boolean status = new Boolean((String)configuration.getProperties().get("consumer"));
                if (status.booleanValue()) {
                    this.eventSwitch.turnOn();
                } else {
                    this.eventSwitch.turnOff();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.eventSwitch;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

