/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle.shell;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.karaf.cellar.bundle.BundleState;
import org.apache.karaf.cellar.bundle.ClusterBundleEvent;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="bundle-install", description="Install bundles in a cluster group")
@Service
public class InstallBundleCommand
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="urls", description="Bundle URLs separated by whitespace", required=true, multiValued=true)
    List<String> urls;
    @Option(name="-s", aliases={"--start"}, description="Start the bundle after installation", required=false, multiValued=false)
    boolean start;
    @Option(name="-l", aliases={"--start-level"}, description="Set the start level of the bundle", required=false, multiValued=false)
    Integer level;
    @Reference
    private EventProducer eventProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            System.err.println("Cluster event producer is OFF");
            return null;
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        for (String url : this.urls) {
            if (support.isAllowed(group, "bundle", url, EventType.OUTBOUND).booleanValue()) {
                ClusterBundleEvent event;
                JarInputStream jarInputStream = new JarInputStream(new URL(url).openStream());
                Manifest manifest = jarInputStream.getManifest();
                if (manifest == null) {
                    System.err.println("Bundle location " + url + " doesn't seem correct");
                    continue;
                }
                String name = manifest.getMainAttributes().getValue("Bundle-Name");
                String symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (name == null) {
                    name = symbolicName;
                }
                if (name == null) {
                    name = url;
                }
                String version = manifest.getMainAttributes().getValue("Bundle-Version");
                jarInputStream.close();
                ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                try {
                    Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + this.groupName);
                    BundleState state = new BundleState();
                    state.setName(name);
                    state.setSymbolicName(symbolicName);
                    state.setVersion(version);
                    state.setStartLevel(this.level);
                    state.setId(clusterBundles.size());
                    state.setLocation(url);
                    if (this.start) {
                        state.setStatus(32);
                    } else {
                        state.setStatus(2);
                    }
                    clusterBundles.put(symbolicName + "/" + version, state);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
                if (this.start) {
                    event = new ClusterBundleEvent(symbolicName, version, url, this.level, 32);
                    event.setSourceGroup(group);
                    event.setSourceNode(this.clusterManager.getNode());
                } else {
                    event = new ClusterBundleEvent(symbolicName, version, url, this.level, 2);
                    event.setSourceGroup(group);
                    event.setSourceNode(this.clusterManager.getNode());
                }
                this.eventProducer.produce((Event)event);
                continue;
            }
            System.err.println("Bundle location " + url + " is blocked outbound for cluster group " + this.groupName);
        }
        return null;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

