/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedCamelHealthMBean;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ObjectHelper;

public class ManagedCamelHealth
implements ManagedCamelHealthMBean {
    private final CamelContext context;

    public ManagedCamelHealth(CamelContext context) {
        this.context = context;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public boolean getIsHealthy() {
        for (HealthCheck.Result result : HealthCheckHelper.invoke(this.context)) {
            if (result.getState() != HealthCheck.State.DOWN) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<String> getHealthChecksIDs() {
        HealthCheckRegistry registry = this.context.getHealthCheckRegistry();
        if (registry != null) {
            return registry.getCheckIDs();
        }
        return Collections.emptyList();
    }

    @Override
    public TabularData details() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.camelHealthDetailsTabularType());
            CompositeType type = CamelOpenMBeanTypes.camelHealthDetailsCompositeType();
            for (HealthCheck.Result result : HealthCheckHelper.invoke(this.context)) {
                CompositeDataSupport data = new CompositeDataSupport(type, new String[]{"id", "group", "state", "enabled", "interval", "failureThreshold"}, new Object[]{result.getCheck().getId(), result.getCheck().getGroup(), result.getState().name(), result.getCheck().getConfiguration().isEnabled(), result.getCheck().getConfiguration().getInterval() != null ? Long.valueOf(result.getCheck().getConfiguration().getInterval().toMillis()) : null, result.getCheck().getConfiguration().getFailureThreshold()});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public String invoke(String id) {
        Optional<HealthCheck.Result> result = HealthCheckHelper.invoke(this.context, id, Collections.emptyMap());
        return result.map(r -> r.getState().name()).orElse(HealthCheck.State.UNKNOWN.name());
    }
}

