/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.services;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.router.api.ExportConfiguration;
import org.apache.unomi.router.api.ImportExportConfiguration;
import org.apache.unomi.router.api.RouterConstants;
import org.apache.unomi.router.api.RouterUtils;
import org.apache.unomi.router.api.services.ProfileExportService;
import org.apache.unomi.router.services.AbstractCustomServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileExportServiceImpl
extends AbstractCustomServiceImpl
implements ProfileExportService {
    private static final Logger logger = LoggerFactory.getLogger((String)ProfileExportServiceImpl.class.getName());
    private ConfigSharingService configSharingService;

    public String extractProfilesBySegment(ExportConfiguration exportConfiguration) {
        List profileList = this.persistenceService.query("segments", (String)exportConfiguration.getProperty("segment"), null, Profile.class);
        StringBuilder csvContent = new StringBuilder();
        for (Profile profile : profileList) {
            csvContent.append(this.convertProfileToCSVLine(profile, exportConfiguration));
            csvContent.append(RouterUtils.getCharFromLineSeparator((String)exportConfiguration.getLineSeparator()));
        }
        logger.debug("Exporting {} extracted profiles.", (Object)profileList.size());
        HashMap<Object, Number> execution = new HashMap<Object, Number>();
        execution.put(RouterConstants.KEY_EXECS_DATE, new Date().getTime());
        execution.put(RouterConstants.KEY_EXECS_EXTRACTED, profileList.size());
        exportConfiguration = (ExportConfiguration)RouterUtils.addExecutionEntry((ImportExportConfiguration)exportConfiguration, execution, (int)Integer.parseInt((String)this.configSharingService.getProperty("historySize")));
        this.persistenceService.save((Item)exportConfiguration);
        return csvContent.toString();
    }

    public String convertProfileToCSVLine(Profile profile, ExportConfiguration exportConfiguration) {
        List propertiesDef = this.persistenceService.query("target", "profiles", null, PropertyType.class);
        Map mapping = (Map)exportConfiguration.getProperty("mapping");
        String lineToWrite = "";
        for (int i = 0; i < mapping.size(); ++i) {
            String propertyName = (String)mapping.get(String.valueOf(i));
            if (propertyName == null) {
                logger.error("No index {} found in the provided mapping!", (Object)i);
                return "";
            }
            PropertyType propType = RouterUtils.getPropertyTypeById((Collection)propertiesDef, (String)propertyName);
            Object propertyValue = profile.getProperty(propertyName);
            if (propType != null && BooleanUtils.isTrue((Boolean)propType.isMultivalued())) {
                if (propertyValue != null) {
                    List multiValue = (List)propertyValue;
                    lineToWrite = lineToWrite + (StringUtils.isNotBlank((CharSequence)exportConfiguration.getMultiValueDelimiter()) ? Character.valueOf(exportConfiguration.getMultiValueDelimiter().charAt(0)) : "");
                    int j = 0;
                    for (String entry : multiValue) {
                        lineToWrite = lineToWrite + entry.replaceAll("\"", "\"\"");
                        if (j + 1 < multiValue.size()) {
                            lineToWrite = lineToWrite + exportConfiguration.getMultiValueSeparator();
                        }
                        ++j;
                    }
                    lineToWrite = lineToWrite + (StringUtils.isNotBlank((CharSequence)exportConfiguration.getMultiValueDelimiter()) ? Character.valueOf(exportConfiguration.getMultiValueDelimiter().charAt(1)) : "");
                } else {
                    lineToWrite = lineToWrite + "";
                }
            } else if (propertyValue != null) {
                if (StringUtils.contains((CharSequence)(propertyValue = propertyValue.toString().replaceAll("\"", "\"\"")).toString(), (CharSequence)exportConfiguration.getColumnSeparator())) {
                    propertyValue = "\"" + propertyValue + "\"";
                }
                lineToWrite = lineToWrite + propertyValue.toString();
            } else {
                lineToWrite = lineToWrite + "";
            }
            if (i + 1 >= mapping.size()) continue;
            lineToWrite = lineToWrite + exportConfiguration.getColumnSeparator();
        }
        return lineToWrite;
    }

    public void setConfigSharingService(ConfigSharingService configSharingService) {
        this.configSharingService = configSharingService;
    }
}

