/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.buffer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.uniffle.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBuffer<K, V>
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(WriteBuffer.class);
    private int partitionId;
    private Serializer<K> keySerializer;
    private Serializer<V> valSerializer;
    private long maxSegmentSize;
    private final RawComparator<K> comparator;
    private int dataLength = 0;
    private int currentOffset = 0;
    private int currentIndex = 0;
    private long sortTime = 0L;
    private long copyTime = 0L;
    private boolean isNeedSorted = false;
    private final List<WrappedBuffer> buffers = Lists.newArrayList();
    private final List<Record<K>> records = Lists.newArrayList();

    public WriteBuffer(boolean isNeedSorted, int partitionId, RawComparator<K> comparator, long maxSegmentSize, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.partitionId = partitionId;
        this.comparator = comparator;
        this.maxSegmentSize = maxSegmentSize;
        this.keySerializer = keySerializer;
        this.valSerializer = valueSerializer;
        this.isNeedSorted = isNeedSorted;
    }

    public int addRecord(K key, V value) throws IOException {
        this.keySerializer.open((OutputStream)this);
        this.valSerializer.open((OutputStream)this);
        int lastOffSet = this.currentOffset;
        int lastIndex = this.currentIndex;
        int lastDataLength = this.dataLength;
        int keyIndex = lastIndex;
        this.keySerializer.serialize(key);
        int keyLength = this.dataLength - lastDataLength;
        int keyOffset = lastOffSet;
        if (this.compact(lastIndex, lastOffSet, keyLength)) {
            keyOffset = lastOffSet;
            keyIndex = lastIndex;
        }
        lastDataLength = this.dataLength;
        this.valSerializer.serialize(value);
        int valueLength = this.dataLength - lastDataLength;
        this.records.add(new Record(keyIndex, keyOffset, keyLength, valueLength));
        return keyLength + valueLength;
    }

    public void clear() {
        this.buffers.clear();
        this.records.clear();
    }

    public synchronized byte[] getData() {
        int extraSize = 0;
        for (Record<K> record : this.records) {
            extraSize += WritableUtils.getVIntSize((long)record.getKeyLength());
            extraSize += WritableUtils.getVIntSize((long)record.getValueLength());
        }
        extraSize += WritableUtils.getVIntSize((long)-1L);
        byte[] data = new byte[this.dataLength + (extraSize += WritableUtils.getVIntSize((long)-1L))];
        int offset = 0;
        long startSort = System.currentTimeMillis();
        if (this.isNeedSorted) {
            this.records.sort(new Comparator<Record<K>>(){

                @Override
                public int compare(Record<K> o1, Record<K> o2) {
                    return WriteBuffer.this.comparator.compare(((WrappedBuffer)WriteBuffer.this.buffers.get(o1.getKeyIndex())).getBuffer(), o1.getKeyOffSet(), o1.getKeyLength(), ((WrappedBuffer)WriteBuffer.this.buffers.get(o2.getKeyIndex())).getBuffer(), o2.getKeyOffSet(), o2.getKeyLength());
                }
            });
        }
        long startCopy = System.currentTimeMillis();
        this.sortTime += startCopy - startSort;
        for (Record<K> record : this.records) {
            offset = this.writeDataInt(data, offset, record.getKeyLength());
            offset = this.writeDataInt(data, offset, record.getValueLength());
            int recordLength = record.getKeyLength() + record.getValueLength();
            int copyOffset = record.getKeyOffSet();
            int copyIndex = record.getKeyIndex();
            while (recordLength > 0) {
                byte[] srcBytes = this.buffers.get(copyIndex).getBuffer();
                int length = copyOffset + recordLength;
                int copyLength = recordLength;
                if (length > srcBytes.length) {
                    copyLength = srcBytes.length - copyOffset;
                }
                System.arraycopy(srcBytes, copyOffset, data, offset, copyLength);
                copyOffset = 0;
                ++copyIndex;
                recordLength -= copyLength;
                offset += copyLength;
            }
        }
        offset = this.writeDataInt(data, offset, -1L);
        this.writeDataInt(data, offset, -1L);
        this.copyTime += System.currentTimeMillis() - startCopy;
        return data;
    }

    private boolean compact(int lastIndex, int lastOffset, int dataLength) {
        if (lastIndex != this.currentIndex) {
            int i;
            if (LOG.isDebugEnabled()) {
                LOG.debug("compact lastIndex {}, currentIndex {}, lastOffset {} currentOffset {} dataLength {}", new Object[]{lastIndex, this.currentIndex, lastOffset, this.currentOffset, dataLength});
            }
            WrappedBuffer buffer = new WrappedBuffer(lastOffset + dataLength);
            int offset = 0;
            for (i = lastIndex; i < this.currentIndex; ++i) {
                byte[] sourceBuffer = this.buffers.get(i).getBuffer();
                System.arraycopy(sourceBuffer, 0, buffer.getBuffer(), offset, sourceBuffer.length);
                offset += sourceBuffer.length;
            }
            System.arraycopy(this.buffers.get(this.currentIndex).getBuffer(), 0, buffer.getBuffer(), offset, this.currentOffset);
            for (i = this.currentIndex; i >= lastIndex; --i) {
                this.buffers.remove(i);
            }
            this.buffers.add(buffer);
            this.currentOffset = 0;
            WrappedBuffer anotherBuffer = new WrappedBuffer((int)this.maxSegmentSize);
            this.buffers.add(anotherBuffer);
            this.currentIndex = this.buffers.size() - 1;
            return true;
        }
        return false;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffers.isEmpty()) {
            this.buffers.add(new WrappedBuffer((int)this.maxSegmentSize));
        }
        if ((long)(1 + this.currentOffset) > this.maxSegmentSize) {
            ++this.currentIndex;
            this.currentOffset = 0;
            this.buffers.add(new WrappedBuffer((int)this.maxSegmentSize));
        }
        WrappedBuffer buffer = this.buffers.get(this.currentIndex);
        buffer.getBuffer()[this.currentOffset] = (byte)b;
        ++this.currentOffset;
        ++this.dataLength;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.buffers.isEmpty()) {
            this.buffers.add(new WrappedBuffer((int)this.maxSegmentSize));
        }
        int bufferNum = (int)((long)(this.currentOffset + len) / this.maxSegmentSize);
        for (int i = 0; i < bufferNum; ++i) {
            this.buffers.add(new WrappedBuffer((int)this.maxSegmentSize));
        }
        int index = this.currentIndex;
        int offset = this.currentOffset;
        int srcPos = 0;
        while (len > 0) {
            int copyLength = 0;
            if ((long)(offset + len) >= this.maxSegmentSize) {
                copyLength = (int)(this.maxSegmentSize - (long)offset);
                this.currentOffset = 0;
            } else {
                copyLength = len;
                this.currentOffset += len;
            }
            System.arraycopy(b, srcPos, this.buffers.get(index).getBuffer(), offset, copyLength);
            offset = 0;
            srcPos += copyLength;
            ++index;
            len -= copyLength;
            this.dataLength += copyLength;
        }
        this.currentIndex += bufferNum;
    }

    private int writeDataInt(byte[] data, int offset, long dataInt) {
        if (dataInt >= -112L && dataInt <= 127L) {
            data[offset] = (byte)dataInt;
            ++offset;
        } else {
            int len = -112;
            if (dataInt < 0L) {
                dataInt ^= 0xFFFFFFFFFFFFFFFFL;
                len = -120;
            }
            long tmp = dataInt;
            while (tmp != 0L) {
                tmp >>= 8;
                --len;
            }
            data[offset] = (byte)len;
            ++offset;
            for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
                int shiftBits = (idx - 1) * 8;
                long mask = 255L << shiftBits;
                data[offset] = (byte)((dataInt & mask) >> shiftBits);
                ++offset;
            }
        }
        return offset;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getCopyTime() {
        return this.copyTime;
    }

    public long getSortTime() {
        return this.sortTime;
    }

    private static final class WrappedBuffer {
        private byte[] buffer;
        private int size;

        WrappedBuffer(int size) {
            this.buffer = new byte[size];
            this.size = size;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public int getSize() {
            return this.size;
        }
    }

    private static final class Record<K> {
        private final int keyIndex;
        private final int keyOffSet;
        private final int keyLength;
        private final int valueLength;

        Record(int keyIndex, int keyOffset, int keyLength, int valueLength) {
            this.keyIndex = keyIndex;
            this.keyOffSet = keyOffset;
            this.keyLength = keyLength;
            this.valueLength = valueLength;
        }

        public int getKeyIndex() {
            return this.keyIndex;
        }

        public int getKeyOffSet() {
            return this.keyOffSet;
        }

        public int getKeyLength() {
            return this.keyLength;
        }

        public int getValueLength() {
            return this.valueLength;
        }
    }
}

