/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.io.netty.handler.codec.http.websocketx;

import org.apache.uniffle.io.netty.channel.Channel;
import org.apache.uniffle.io.netty.channel.ChannelFuture;
import org.apache.uniffle.io.netty.channel.ChannelPromise;
import org.apache.uniffle.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.uniffle.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.uniffle.io.netty.handler.codec.http.HttpRequest;
import org.apache.uniffle.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.uniffle.io.netty.handler.codec.http.HttpUtil;
import org.apache.uniffle.io.netty.handler.codec.http.HttpVersion;
import org.apache.uniffle.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import org.apache.uniffle.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.apache.uniffle.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker00;
import org.apache.uniffle.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker07;
import org.apache.uniffle.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker08;
import org.apache.uniffle.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker13;
import org.apache.uniffle.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.apache.uniffle.io.netty.util.internal.ObjectUtil;

public class WebSocketServerHandshakerFactory {
    private final String webSocketURL;
    private final String subprotocols;
    private final WebSocketDecoderConfig decoderConfig;

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions) {
        this(webSocketURL, subprotocols, allowExtensions, 65536);
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        this(webSocketURL, subprotocols, allowExtensions, maxFramePayloadLength, false);
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength, boolean allowMaskMismatch) {
        this(webSocketURL, subprotocols, WebSocketDecoderConfig.newBuilder().allowExtensions(allowExtensions).maxFramePayloadLength(maxFramePayloadLength).allowMaskMismatch(allowMaskMismatch).build());
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, WebSocketDecoderConfig decoderConfig) {
        this.webSocketURL = webSocketURL;
        this.subprotocols = subprotocols;
        this.decoderConfig = ObjectUtil.checkNotNull(decoderConfig, "decoderConfig");
    }

    public WebSocketServerHandshaker newHandshaker(HttpRequest req) {
        String version = req.headers().get(HttpHeaderNames.SEC_WEBSOCKET_VERSION);
        if (version != null) {
            if (version.equals(WebSocketVersion.V13.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker13(this.webSocketURL, this.subprotocols, this.decoderConfig);
            }
            if (version.equals(WebSocketVersion.V08.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker08(this.webSocketURL, this.subprotocols, this.decoderConfig);
            }
            if (version.equals(WebSocketVersion.V07.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker07(this.webSocketURL, this.subprotocols, this.decoderConfig);
            }
            return null;
        }
        return new WebSocketServerHandshaker00(this.webSocketURL, this.subprotocols, this.decoderConfig);
    }

    @Deprecated
    public static void sendUnsupportedWebSocketVersionResponse(Channel channel) {
        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel);
    }

    public static ChannelFuture sendUnsupportedVersionResponse(Channel channel) {
        return WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel, channel.newPromise());
    }

    public static ChannelFuture sendUnsupportedVersionResponse(Channel channel, ChannelPromise promise) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UPGRADE_REQUIRED, channel.alloc().buffer(0));
        res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)WebSocketVersion.V13.toHttpHeaderValue());
        HttpUtil.setContentLength(res, 0L);
        return channel.writeAndFlush(res, promise);
    }
}

