/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.web.resource;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.POST;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.PathParam;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.QueryParam;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.uniffle.common.Application;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.coordinator.ApplicationManager;
import org.apache.uniffle.coordinator.ClusterManager;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.web.Response;
import org.apache.uniffle.coordinator.web.request.ApplicationRequest;
import org.apache.uniffle.coordinator.web.request.CancelDecommissionRequest;
import org.apache.uniffle.coordinator.web.request.DecommissionRequest;
import org.apache.uniffle.coordinator.web.resource.BaseResource;

@Produces(value={"application/json"})
public class ServerResource
extends BaseResource {
    @Context
    protected ServletContext servletContext;

    @GET
    @Path(value="/status")
    public Response<String> status() {
        return this.execute(() -> "success");
    }

    @GET
    @Path(value="/nodes/{id}")
    public Response<ServerNode> node(@PathParam(value="id") String id) {
        return this.execute(() -> this.getClusterManager().getServerNodeById(id));
    }

    @GET
    @Path(value="/nodes")
    public Response<List<ServerNode>> nodes(@QueryParam(value="status") String status) {
        ClusterManager clusterManager = this.getClusterManager();
        List<ServerNode> serverList = ServerStatus.UNHEALTHY.name().equalsIgnoreCase(status) ? clusterManager.getUnhealthyServerList() : (ServerStatus.LOST.name().equalsIgnoreCase(status) ? clusterManager.getLostServerList() : clusterManager.list());
        serverList = serverList.stream().filter(server -> status == null || server.getStatus().toString().equals(status)).collect(Collectors.toList());
        serverList.sort(Comparator.comparing(ServerNode::getId));
        return Response.success(serverList);
    }

    @POST
    @Path(value="/cancelDecommission")
    public Response<Object> cancelDecommission(CancelDecommissionRequest params) {
        return this.execute(() -> {
            assert (CollectionUtils.isNotEmpty(params.getServerIds())) : "Parameter[serverIds] should not be null!";
            params.getServerIds().forEach(this.getClusterManager()::cancelDecommission);
            return null;
        });
    }

    @POST
    @Path(value="/{id}/cancelDecommission")
    public Response<Object> cancelDecommission(@PathParam(value="id") String serverId) {
        return this.execute(() -> {
            this.getClusterManager().cancelDecommission(serverId);
            return null;
        });
    }

    @POST
    @Path(value="/decommission")
    public Response<Object> decommission(DecommissionRequest params) {
        return this.execute(() -> {
            assert (CollectionUtils.isNotEmpty(params.getServerIds())) : "Parameter[serverIds] should not be null!";
            params.getServerIds().forEach(this.getClusterManager()::decommission);
            return null;
        });
    }

    @POST
    @Path(value="/{id}/decommission")
    @Produces(value={"application/json"})
    public Response<Object> decommission(@PathParam(value="id") String serverId) {
        return this.execute(() -> {
            this.getClusterManager().decommission(serverId);
            return null;
        });
    }

    @POST
    @Path(value="/applications")
    @Produces(value={"application/json"})
    public Response<Object> application(ApplicationRequest params) {
        if (params == null) {
            return Response.fail("ApplicationRequest Is not null");
        }
        HashSet<String> filterApplications = new HashSet();
        if (CollectionUtils.isNotEmpty(params.getApplications())) {
            filterApplications = params.getApplications();
        }
        int currentPage = params.getCurrentPage();
        int pageSize = params.getPageSize();
        String startTime = params.getHeartBeatStartTime();
        String endTime = params.getHeartBeatEndTime();
        String appIdRegex = params.getAppIdRegex();
        try {
            ApplicationManager applicationManager = this.getApplicationManager();
            List<Application> applicationSet = applicationManager.getApplications(filterApplications, pageSize, currentPage, startTime, endTime, appIdRegex);
            return Response.success(applicationSet);
        }
        catch (Exception e) {
            return Response.fail(e.getMessage());
        }
    }

    private ClusterManager getClusterManager() {
        return (ClusterManager)this.servletContext.getAttribute(ClusterManager.class.getCanonicalName());
    }

    private ApplicationManager getApplicationManager() {
        return (ApplicationManager)this.servletContext.getAttribute(ApplicationManager.class.getCanonicalName());
    }
}

