/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_UnsupportedOperationException;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.analysis_engine.TextAnalysisEngine;
import org.apache.uima.analysis_engine.impl.AnalysisEngineImplBase;
import org.apache.uima.analysis_engine.impl.AnalysisEngineProcessorStub;
import org.apache.uima.analysis_engine.impl.EmptyCasIterator;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.Level;
import org.apache.uima.util.UimaTimer;

public abstract class AnalysisEngineProcessorAdapter
extends AnalysisEngineImplBase
implements TextAnalysisEngine,
CasConsumer {
    private static final Class<AnalysisEngineProcessorAdapter> CLASS_NAME = AnalysisEngineProcessorAdapter.class;
    private AnalysisEngineProcessorStub mStub;
    @Deprecated(since="3.6.0")
    private ResourceMetaData mCachedMetaData;
    private UimaTimer mTimer = UIMAFramework.newTimer();

    protected void setStub(AnalysisEngineProcessorStub aStub) {
        this.mStub = aStub;
    }

    protected AnalysisEngineProcessorStub getStub() {
        return this.mStub;
    }

    @Override
    public ResourceMetaData getMetaData() {
        return this.getStub() != null ? this.getStub().getMetaData() : null;
    }

    @Override
    public void destroy() {
        if (this.getStub() != null) {
            this.getStub().destroy();
        }
        super.destroy();
    }

    @Override
    public CasIterator processAndOutputNewCASes(CAS aCAS) throws AnalysisEngineProcessException {
        this.mTimer.startIt();
        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "process", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_begin__FINE", this.getResourceName());
        try {
            this.getStub().process(aCAS);
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "process", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_end__FINE", this.getResourceName());
            EmptyCasIterator emptyCasIterator = new EmptyCasIterator();
            return emptyCasIterator;
        }
        catch (AnalysisEngineProcessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException(e);
        }
        finally {
            this.mTimer.stopIt();
            this.getMBean().reportServiceCallTime((int)this.mTimer.getDuration());
            this.getMBean().incrementCASesProcessed();
        }
    }

    @Override
    public void reconfigure() throws ResourceConfigurationException {
        throw new UIMA_UnsupportedOperationException("shared_resource_not_reconfigurable", new Object[0]);
    }

    @Override
    public Object getConfigParameterValue(String aGroupName, String aParamName) {
        return this.getMetaData().getConfigurationParameterSettings().getParameterValue(aGroupName, aParamName);
    }

    @Override
    public Object getConfigParameterValue(String aParamName) {
        return this.getMetaData().getConfigurationParameterSettings().getParameterValue(aParamName);
    }

    @Override
    public void setConfigParameterValue(String aParamName, Object aValue) {
        throw new UIMA_UnsupportedOperationException("shared_resource_not_reconfigurable", new Object[0]);
    }

    @Override
    public void setConfigParameterValue(String aGroupName, String aParamName, Object aValue) {
        throw new UIMA_UnsupportedOperationException("shared_resource_not_reconfigurable", new Object[0]);
    }

    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
        this.getStub().batchProcessComplete();
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.getStub().collectionProcessComplete();
    }

    protected String getResourceName() {
        return this.getMetaData().getName();
    }
}

