/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.uima.pear.insd.edit.vars;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/**
 * Label provider for the VarValViewerHandler.
 *
 * @see org.eclipse.jface.viewers.LabelProvider
 */
class VarValLabelProvider extends LabelProvider implements ITableLabelProvider {

  /**
   * Gets the column text.
   *
   * @param element
   *          the element
   * @param columnIndex
   *          the column index
   * @return the column text
   * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
   */
  @Override
  public String getColumnText(Object element, int columnIndex) {
    String result = "";
    VarVal tableRow = (VarVal) element;
    switch (columnIndex) {
      case 0:
        result = tableRow.getVarName();
        break;
      case 1:
        result = tableRow.getVarValue();
        break;
      default:
        break;
    }
    return result;
  }

  /**
   * Gets the column image.
   *
   * @param element
   *          the element
   * @param columnIndex
   *          the column index
   * @return the column image
   * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
   */
  @Override
  public Image getColumnImage(Object element, int columnIndex) {
    return null;
  }

}
