/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.insd.edit.vars;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.uima.pear.insd.edit.vars.IVarValListViewer;
import org.apache.uima.pear.insd.edit.vars.VarVal;

public class VarValList {
    public Vector tableRows = new Vector(10);
    private Set changeListeners = new HashSet();

    public VarValList() {
        this.initData();
    }

    private void initData() {
    }

    public Vector getTableRows() {
        return this.tableRows;
    }

    public boolean addTableRow(VarVal tableRow) {
        if (!this.isDuplicate(tableRow)) {
            this.tableRows.add(tableRow);
            return true;
        }
        return false;
    }

    public boolean addTableRow() {
        VarVal tableRow = new VarVal("New_Variable", "Value");
        if (!this.isDuplicate(tableRow)) {
            this.tableRows.add(this.tableRows.size(), tableRow);
            Iterator iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                ((IVarValListViewer)iterator.next()).addTableRow(tableRow);
            }
            return true;
        }
        return false;
    }

    private boolean isDuplicate(VarVal tableRow) {
        boolean duplicate = false;
        String varName = tableRow.getVarName();
        for (VarVal vv : this.tableRows) {
            if (!vv.getVarName().equals(varName)) continue;
            duplicate = true;
        }
        return duplicate;
    }

    public void removeTableRow(VarVal tableRow) {
        this.tableRows.remove(tableRow);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IVarValListViewer)iterator.next()).removeTableRow(tableRow);
        }
    }

    public void tableRowChanged(VarVal tableRow) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IVarValListViewer)iterator.next()).updateTableRow(tableRow);
        }
    }

    public void removeChangeListener(IVarValListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IVarValListViewer viewer) {
        this.changeListeners.add(viewer);
    }
}

