/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.util.ProcessTrace;

public class EntityProcessStatusImpl
implements EntityProcessStatus {
    private static final long serialVersionUID = -5101356145458558249L;
    ProcessTrace prT;
    HashMap eventMap = new HashMap();
    List exceptionList = new ArrayList();
    List failedList = new ArrayList();
    HashMap resultHM = new HashMap();
    private boolean isSkipped = false;
    public boolean isProcessed = true;

    public EntityProcessStatusImpl(ProcessTrace p) {
        this.prT = p;
    }

    public EntityProcessStatusImpl(ProcessTrace p, boolean aSkip) {
        this.prT = p;
        this.isSkipped = aSkip;
    }

    public boolean isException() {
        return this.failedList.size() > 0;
    }

    public String getStatusMessage() {
        if (this.failedList.size() > 0) {
            return "failed";
        }
        return "success";
    }

    public List getExceptions() {
        return this.exceptionList;
    }

    public List getFailedComponentNames() {
        return this.failedList;
    }

    public void addEventStatus(String aEventName, String aResultS, Throwable aE) {
        EventLog eL = new EventLog(aResultS, aE);
        this.eventMap.put(aEventName, eL);
        if (!aResultS.equalsIgnoreCase("success")) {
            this.failedList.add(aEventName);
            this.exceptionList.add(aE);
        }
        this.resultHM.put(aEventName, aE);
    }

    public ProcessTrace getProcessTrace() {
        return this.prT;
    }

    public void printEventLog() {
        for (Map.Entry obj : this.eventMap.entrySet()) {
            String key = (String)obj.getKey();
            EventLog eL = (EventLog)obj.getValue();
            System.out.println(" EVENT " + key + "  Result " + eL.status);
            if (eL.exception == null) continue;
            eL.exception.printStackTrace();
        }
        for (int j = 0; j < this.failedList.size(); ++j) {
            System.out.println(" failed component name " + this.failedList.get(j));
        }
    }

    public boolean isEntitySkipped() {
        return this.isSkipped;
    }

    static class EventLog {
        String status;
        Throwable exception;

        public EventLog(String stats, Throwable e) {
            this.status = stats;
            this.exception = e;
        }
    }
}

