/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.util.ContractUtils;

public abstract class FieldReference
extends MemberReference {
    public abstract TypeReference getFieldType();

    @Override
    public boolean containsGenericParameters() {
        TypeReference fieldType = this.getFieldType();
        return fieldType != null && fieldType.containsGenericParameters() || super.containsGenericParameters();
    }

    @Override
    public boolean isEquivalentTo(MemberReference member) {
        if (super.isEquivalentTo(member)) {
            return true;
        }
        if (member instanceof FieldReference) {
            FieldReference field = (FieldReference)member;
            return StringUtilities.equals((String)field.getName(), (String)this.getName()) && MetadataResolver.areEquivalent(field.getDeclaringType(), this.getDeclaringType());
        }
        return false;
    }

    public FieldDefinition resolve() {
        TypeReference declaringType = this.getDeclaringType();
        if (declaringType == null) {
            throw ContractUtils.unsupported();
        }
        return declaringType.resolve(this);
    }

    @Override
    protected abstract StringBuilder appendName(StringBuilder var1, boolean var2, boolean var3);

    @Override
    protected StringBuilder appendSignature(StringBuilder sb) {
        return this.getFieldType().appendSignature(sb);
    }

    @Override
    protected StringBuilder appendErasedSignature(StringBuilder sb) {
        return this.getFieldType().appendErasedSignature(sb);
    }
}

