/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;

class ImportResolver<DESCRIPTOR extends MetaDataObject, COLLECTIBLE extends MetaDataObject> {
    private Function<DESCRIPTOR, DescriptorAdapter<DESCRIPTOR, COLLECTIBLE>> adapterFactory;

    ImportResolver(Function<DESCRIPTOR, DescriptorAdapter> aAdapterFactory) {
        this.adapterFactory = aAdapterFactory;
    }

    void resolveImports(DESCRIPTOR aDesc, ResourceManager aResourceManager) throws InvalidXMLException {
        this.resolveImports(aDesc, null, aResourceManager);
    }

    @Deprecated
    void resolveImports(DESCRIPTOR aDesc, Collection<String> aAlreadyImportedURLs, ResourceManager aResourceManager) throws InvalidXMLException {
        DescriptorAdapter<DESCRIPTOR, COLLECTIBLE> wrapper = this.adapterFactory.apply(aDesc);
        if (wrapper.getImports() == null || wrapper.getImports().length == 0) {
            return;
        }
        Set originalTypes = Collections.newSetFromMap(new IdentityHashMap());
        originalTypes.addAll(Arrays.asList(wrapper.getCollectibles()));
        ResourceManager resourceManager = aResourceManager;
        if (aResourceManager == null) {
            resourceManager = UIMAFramework.newDefaultResourceManager();
        }
        HashSet<String> alreadyImportedURLs = new HashSet<String>();
        LinkedList<String> stack = new LinkedList<String>();
        if (aAlreadyImportedURLs != null) {
            alreadyImportedURLs.addAll(aAlreadyImportedURLs);
            aAlreadyImportedURLs.forEach(stack::push);
        }
        LinkedHashMap collectedObjects = new LinkedHashMap();
        stack.push(wrapper.unwrap().getSourceUrlString());
        this.resolveImports(wrapper, new HashSet<String>(), collectedObjects, stack, resourceManager);
        stack.pop();
        wrapper.setCollectibles(collectedObjects.values().stream().map(c -> originalTypes.contains(c) ? c : (MetaDataObject)c.clone()).collect(Collectors.toList()));
        wrapper.clearImports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveImports(DescriptorAdapter<DESCRIPTOR, COLLECTIBLE> aWrapper, Set<String> aAlreadyVisited, Map<Key, COLLECTIBLE> aAllCollectedObjects, Deque<String> aStack, ResourceManager aResourceManager) throws InvalidXMLException {
        if (aAlreadyVisited.contains(aWrapper.unwrap().getSourceUrlString())) {
            this.collectAll(aWrapper, aAllCollectedObjects);
            return;
        }
        Import[] imports = aWrapper.getImports();
        if (imports.length == 0) {
            this.collectAll(aWrapper, aAllCollectedObjects);
            return;
        }
        this.collectAll(aWrapper, aAllCollectedObjects);
        Map<String, XMLizable> importCache = ((ResourceManager_impl)aResourceManager).getImportCache();
        for (Import imp : imports) {
            URL absUrl;
            String absUrlString;
            if (imp instanceof Import_impl) {
                ((Import_impl)imp).setSourceUrlIfNull(aWrapper.unwrap().getSourceUrl());
            }
            if (aWrapper.unwrap().getSourceUrlString().equals(imp.getLocation()) || aStack.contains(absUrlString = (absUrl = imp.findAbsoluteUrl(aResourceManager)).toString())) continue;
            aStack.push(absUrlString);
            Map<String, XMLizable> map = importCache;
            synchronized (map) {
                DescriptorAdapter<DESCRIPTOR, COLLECTIBLE> importedTSAdapter = this.adapterFactory.apply(this.getOrLoadDescription(imp, absUrl, importCache, aWrapper));
                this.resolveImports(importedTSAdapter, aAlreadyVisited, aAllCollectedObjects, aStack, aResourceManager);
            }
            aStack.pop();
        }
        aAlreadyVisited.add(aWrapper.unwrap().getSourceUrlString());
    }

    private void collectAll(DescriptorAdapter<DESCRIPTOR, COLLECTIBLE> aWrapper, Map<Key, COLLECTIBLE> aAllCollectibleObjects) {
        MetaDataObject[] collectibles = (MetaDataObject[])aWrapper.getCollectibles();
        for (int i = 0; i < collectibles.length; ++i) {
            aAllCollectibleObjects.put(new Key(this, collectibles[i]), collectibles[i]);
        }
    }

    private DESCRIPTOR getOrLoadDescription(Import aImport, URL aAbsUrl, Map<String, XMLizable> aImportCache, DescriptorAdapter<DESCRIPTOR, COLLECTIBLE> aWrapper) throws InvalidXMLException {
        XMLizable cachedDescriptor;
        Class<DESCRIPTOR> descClass = aWrapper.getDescriptorClass();
        if (descClass.isInstance(cachedDescriptor = aImportCache.get(aAbsUrl.toString()))) {
            return (DESCRIPTOR)((MetaDataObject)descClass.cast(cachedDescriptor));
        }
        return this.loadDescriptor(aImport, aAbsUrl, aImportCache, aWrapper.getParser());
    }

    private DESCRIPTOR loadDescriptor(Import aImport, URL aAbsUrl, Map<String, XMLizable> aImportCache, ParserFunction<DESCRIPTOR> aParserFunction) throws InvalidXMLException {
        String urlString = aAbsUrl.toString();
        try {
            XMLInputSource input = new XMLInputSource(aAbsUrl);
            MetaDataObject descriptor = (MetaDataObject)aParserFunction.apply(input);
            aImportCache.put(urlString, descriptor);
            return (DESCRIPTOR)descriptor;
        }
        catch (IOException e) {
            throw new InvalidXMLException("import_failed_could_not_read_from_url", new Object[]{aAbsUrl, aImport.getLocation()}, e);
        }
    }

    private static class Key {
        private final COLLECTIBLE wrapped;
        final /* synthetic */ ImportResolver this$0;

        public Key(COLLECTIBLE aObj) {
            this.this$0 = var1_1;
            this.wrapped = aObj;
        }

        public int hashCode() {
            return System.identityHashCode(this.wrapped);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return this.wrapped == other.wrapped;
        }
    }

    @FunctionalInterface
    static interface ParserFunction<DESCRIPTOR> {
        public DESCRIPTOR apply(XMLInputSource var1) throws InvalidXMLException;
    }

    static interface DescriptorAdapter<DESCRIPTOR, COLLECTIBLE> {
        public Import[] getImports();

        public void clearImports();

        public void setCollectibles(Collection<COLLECTIBLE> var1);

        public COLLECTIBLE[] getCollectibles();

        public MetaDataObject unwrap();

        public Class<DESCRIPTOR> getDescriptorClass();

        public Class<COLLECTIBLE> getCollectedClass();

        public ParserFunction<DESCRIPTOR> getParser();
    }
}

