/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeImpl_string;
import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TypeSystem2Xml {
    public static void typeSystem2Xml(TypeSystem aTypeSystem, OutputStream aOutputStream) throws SAXException, IOException {
        XMLSerializer sax2xml = new XMLSerializer(aOutputStream);
        TypeSystem2Xml.typeSystem2Xml(aTypeSystem, sax2xml.getContentHandler());
    }

    public static void typeSystem2Xml(TypeSystem aTypeSystem, ContentHandler aContentHandler) throws SAXException {
        ResourceSpecifierFactory factory = UIMAFramework.getResourceSpecifierFactory();
        TypeSystemDescription tsDesc = factory.createTypeSystemDescription();
        ArrayList<TypeDescription> typeDescs = new ArrayList<TypeDescription>();
        Iterator<Type> typeIterator = aTypeSystem.getTypeIterator();
        while (typeIterator.hasNext()) {
            TypeImpl type = (TypeImpl)typeIterator.next();
            Type superType = aTypeSystem.getParent(type);
            if (type.getName().startsWith("uima.cas") && type.isFeatureFinal() || type.isArray()) continue;
            TypeDescription typeDesc = factory.createTypeDescription();
            typeDesc.setName(type.getName());
            typeDesc.setSupertypeName(superType.getName());
            LowLevelTypeSystem llts = aTypeSystem.getLowLevelTypeSystem();
            ArrayList<FeatureDescription> featDescs = new ArrayList<FeatureDescription>();
            for (Feature feature : Arrays.asList(type.getFeatureImpls())) {
                if (!feature.getDomain().equals(type)) continue;
                FeatureDescription featDesc = factory.createFeatureDescription();
                featDesc.setName(feature.getShortName());
                Type rangeType = feature.getRange();
                if (rangeType.isArray()) {
                    int typeClass = llts.ll_getTypeClass(llts.ll_getCodeForType(rangeType));
                    String typeName = null;
                    switch (typeClass) {
                        case 14: {
                            typeName = "uima.cas.BooleanArray";
                            break;
                        }
                        case 16: {
                            typeName = "uima.cas.ShortArray";
                            break;
                        }
                        case 15: {
                            typeName = "uima.cas.ByteArray";
                            break;
                        }
                        case 18: {
                            typeName = "uima.cas.DoubleArray";
                            break;
                        }
                        case 5: {
                            typeName = "uima.cas.FloatArray";
                            break;
                        }
                        case 7: {
                            typeName = "uima.cas.FSArray";
                            break;
                        }
                        case 4: {
                            typeName = "uima.cas.IntegerArray";
                            break;
                        }
                        case 17: {
                            typeName = "uima.cas.LongArray";
                            break;
                        }
                        case 6: {
                            typeName = "uima.cas.StringArray";
                        }
                    }
                    featDesc.setRangeTypeName(typeName);
                    featDesc.setElementType(rangeType.getComponentType().getName());
                } else {
                    featDesc.setRangeTypeName(feature.getRange().getName());
                }
                featDescs.add(featDesc);
            }
            FeatureDescription[] featureDescriptionArray = new FeatureDescription[featDescs.size()];
            featDescs.toArray(featureDescriptionArray);
            typeDesc.setFeatures(featureDescriptionArray);
            if (type instanceof TypeImpl_string) {
                LowLevelTypeSystem lts = aTypeSystem.getLowLevelTypeSystem();
                int typeCode = lts.ll_getCodeForType(type);
                String[] strings = lts.ll_getStringSet(typeCode);
                AllowedValue[] allowedVals = new AllowedValue[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    allowedVals[i] = factory.createAllowedValue();
                    allowedVals[i].setString(strings[i]);
                }
                typeDesc.setAllowedValues(allowedVals);
            }
            typeDescs.add(typeDesc);
        }
        TypeDescription[] typeDescArr = new TypeDescription[typeDescs.size()];
        typeDescs.toArray(typeDescArr);
        tsDesc.setTypes(typeDescArr);
        aContentHandler.startDocument();
        tsDesc.toXML(aContentHandler);
        aContentHandler.endDocument();
    }
}

