/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.fsview;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.Images;
import org.apache.uima.caseditor.editor.AbstractAnnotationDocumentListener;
import org.apache.uima.caseditor.editor.FeatureValue;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasEditor;
import org.apache.uima.caseditor.editor.ModelFeatureStructure;
import org.apache.uima.caseditor.editor.action.DeleteFeatureStructureAction;
import org.apache.uima.caseditor.editor.fsview.FeatureStructureLabelProvider;
import org.apache.uima.caseditor.editor.fsview.ITypePaneListener;
import org.apache.uima.caseditor.editor.fsview.TypeCombo;
import org.apache.uima.caseditor.editor.util.StrictTypeConstraint;
import org.apache.uima.jcas.cas.StringArray;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.Page;

public final class FeatureStructureBrowserViewPage
extends Page {
    private static final String LAST_SELECTED_FS_TYPE = "lastSelectedFeatureStructureBrowserViewType";
    private ICasDocument mDocument;
    private ICasEditor mCasEditor;
    private ListViewer mFSList;
    private Composite mInstanceComposite;
    private Type mCurrentType;
    private DeleteFeatureStructureAction mDeleteAction;
    private Action mSelectAllAction;
    private Collection<Type> filterTypes;

    public FeatureStructureBrowserViewPage(ICasEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("editor parameter must not be null!");
        }
        this.mDocument = editor.getDocument();
        this.mCasEditor = editor;
        this.mDeleteAction = new DeleteFeatureStructureAction(this.mCasEditor);
        this.mSelectAllAction = new SelectAllAction();
        TypeSystem ts = this.mDocument.getCAS().getTypeSystem();
        this.filterTypes = new HashSet<Type>();
        this.filterTypes.add(ts.getType("uima.cas.ArrayBase"));
        this.filterTypes.add(ts.getType("uima.cas.BooleanArray"));
        this.filterTypes.add(ts.getType("uima.cas.ByteArray"));
        this.filterTypes.add(ts.getType("uima.cas.LongArray"));
        this.filterTypes.add(ts.getType("uima.cas.ShortArray"));
        this.filterTypes.add(ts.getType("uima.cas.FloatArray"));
        this.filterTypes.add(ts.getType("uima.cas.DoubleArray"));
        this.filterTypes.add(ts.getType("uima.cas.Byte"));
        this.filterTypes.add(ts.getType("uima.cas.AnnotationBase"));
        this.filterTypes.add(ts.getType("uima.cas.Short"));
        this.filterTypes.add(ts.getType("uima.cas.Long"));
        this.filterTypes.add(ts.getType("uima.cas.Float"));
        this.filterTypes.add(ts.getType("uima.cas.Double"));
        this.filterTypes.add(ts.getType("uima.cas.Boolean"));
        this.filterTypes.add(ts.getType("uima.cas.EmptyFloatList"));
        this.filterTypes.add(ts.getType("uima.cas.EmptyFSList"));
        this.filterTypes.add(ts.getType("uima.cas.EmptyIntegerList"));
        this.filterTypes.add(ts.getType("uima.cas.EmptyStringList"));
        this.filterTypes.add(ts.getType("uima.cas.Float"));
        this.filterTypes.add(ts.getType("uima.cas.FloatArray"));
        this.filterTypes.add(ts.getType("uima.cas.FloatList"));
        this.filterTypes.add(ts.getType("uima.cas.FSArray"));
        this.filterTypes.add(ts.getType("uima.cas.FSList"));
        this.filterTypes.add(ts.getType("uima.cas.Integer"));
        this.filterTypes.add(ts.getType("uima.cas.IntegerArray"));
        this.filterTypes.add(ts.getType("uima.cas.IntegerList"));
        this.filterTypes.add(ts.getType("uima.cas.ListBase"));
        this.filterTypes.add(ts.getType("uima.cas.NonEmptyFloatList"));
        this.filterTypes.add(ts.getType("uima.cas.NonEmptyFSList"));
        this.filterTypes.add(ts.getType("uima.cas.NonEmptyIntegerList"));
        this.filterTypes.add(ts.getType("uima.cas.NonEmptyStringList"));
        this.filterTypes.add(ts.getType("uima.cas.Sofa"));
        this.filterTypes.add(ts.getType("uima.cas.String"));
        this.filterTypes.add(ts.getType("uima.cas.StringArray"));
        this.filterTypes.add(ts.getType("uima.cas.StringList"));
    }

    public void createControl(Composite parent) {
        this.mInstanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.mInstanceComposite.setLayout((Layout)layout);
        Composite typePanel = new Composite(this.mInstanceComposite, 0);
        GridData typePanelData = new GridData();
        typePanelData.grabExcessHorizontalSpace = true;
        typePanelData.grabExcessVerticalSpace = false;
        typePanelData.horizontalAlignment = 4;
        typePanel.setLayoutData((Object)typePanelData);
        GridLayout typePanelLayout = new GridLayout();
        typePanelLayout.numColumns = 2;
        typePanel.setLayout((Layout)typePanelLayout);
        Label typeLabel = new Label(typePanel, 0);
        typeLabel.setText("Type: ");
        GridData typeLabelData = new GridData();
        typeLabelData.horizontalAlignment = 16384;
        typeLabel.setLayoutData((Object)typeLabelData);
        TypeCombo typeCombo = new TypeCombo(typePanel);
        typeCombo.setInput(this.mDocument.getCAS().getTypeSystem().getType("uima.cas.TOP"), this.mDocument.getCAS().getTypeSystem(), this.filterTypes);
        GridData typeComboData = new GridData();
        typeComboData.horizontalAlignment = 4;
        typeComboData.grabExcessHorizontalSpace = true;
        typeCombo.setLayoutData(typeComboData);
        final IPreferenceStore store = this.mCasEditor.getCasDocumentProvider().getSessionPreferenceStore(this.mCasEditor.getEditorInput());
        Type lastUsedType = this.mDocument.getType(store.getString(LAST_SELECTED_FS_TYPE));
        if (lastUsedType != null) {
            typeCombo.select(lastUsedType);
        }
        typeCombo.addListener(new ITypePaneListener(){

            @Override
            public void typeChanged(Type newType) {
                store.setValue(FeatureStructureBrowserViewPage.LAST_SELECTED_FS_TYPE, newType.getName());
            }
        });
        this.mFSList = new ListViewer(this.mInstanceComposite, 2562);
        GridData instanceListData = new GridData();
        instanceListData.grabExcessHorizontalSpace = true;
        instanceListData.grabExcessVerticalSpace = true;
        instanceListData.horizontalAlignment = 4;
        instanceListData.verticalAlignment = 4;
        this.mFSList.getList().setLayoutData((Object)instanceListData);
        this.mFSList.setContentProvider((IContentProvider)new FeatureStructureTreeContentProvider(this.mDocument));
        this.mFSList.setLabelProvider((IBaseLabelProvider)new FeatureStructureLabelProvider());
        this.mFSList.setUseHashlookup(true);
        typeCombo.addListener(new ITypePaneListener(){

            @Override
            public void typeChanged(Type newType) {
                FeatureStructureBrowserViewPage.this.mCurrentType = newType;
                FeatureStructureBrowserViewPage.this.mFSList.setInput((Object)newType);
            }
        });
        if (lastUsedType != null) {
            this.mFSList.setInput((Object)lastUsedType);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.mFSList);
    }

    public Control getControl() {
        return this.mInstanceComposite;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        CreateAction createAction = new CreateAction();
        createAction.setText("Create");
        createAction.setImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.ADD));
        toolBarManager.add((IAction)createAction);
        toolBarManager.add((IAction)ActionFactory.DELETE.create(this.getSite().getWorkbenchWindow()));
    }

    public void setActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.mDeleteAction);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.mDeleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.mSelectAllAction);
        super.setActionBars(actionBars);
    }

    public void setFocus() {
        this.mInstanceComposite.setFocus();
    }

    private class SelectAllAction
    extends Action {
        private SelectAllAction() {
        }

        public void run() {
            FeatureStructureBrowserViewPage.this.mFSList.getList().selectAll();
            FeatureStructureBrowserViewPage.this.mFSList.setSelection(FeatureStructureBrowserViewPage.this.mFSList.getSelection());
        }
    }

    private class CreateAction
    extends Action {
        private CreateAction() {
        }

        public void run() {
            if (FeatureStructureBrowserViewPage.this.mCurrentType == null) {
                return;
            }
            FeatureStructure newFeatureStructure = FeatureStructureBrowserViewPage.this.mDocument.getCAS().createFS(FeatureStructureBrowserViewPage.this.mCurrentType);
            FeatureStructureBrowserViewPage.this.mDocument.addFeatureStructure(newFeatureStructure);
            FeatureStructureBrowserViewPage.this.mFSList.refresh();
        }
    }

    final class FeatureStructureTreeContentProvider
    extends AbstractAnnotationDocumentListener
    implements ITreeContentProvider {
        private ICasDocument mDocument;
        private Type mCurrentType;

        FeatureStructureTreeContentProvider(ICasDocument document) {
            this.mDocument = document;
        }

        public Object[] getElements(Object inputElement) {
            if (this.mCurrentType == null) {
                return new Object[0];
            }
            StrictTypeConstraint typeConstrain = new StrictTypeConstraint(this.mCurrentType);
            FSIterator strictTypeIterator = this.mDocument.getCAS().createFilteredIterator(this.mDocument.getCAS().getIndexRepository().getAllIndexedFS(this.mCurrentType), (FSMatchConstraint)typeConstrain);
            LinkedList<ModelFeatureStructure> featureStructureList = new LinkedList<ModelFeatureStructure>();
            while (strictTypeIterator.hasNext()) {
                featureStructureList.add(new ModelFeatureStructure(this.mDocument, (FeatureStructure)strictTypeIterator.next()));
            }
            Object[] featureStructureArray = new ModelFeatureStructure[featureStructureList.size()];
            featureStructureList.toArray(featureStructureArray);
            return featureStructureArray;
        }

        public void dispose() {
            if (this.mDocument != null) {
                this.mDocument.removeChangeListener(this);
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null) {
                this.mDocument.removeChangeListener(this);
            }
            if (newInput == null) {
                this.mCurrentType = null;
                return;
            }
            this.mCurrentType = (Type)newInput;
            this.mDocument.addChangeListener(this);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureStructureBrowserViewPage.this.mFSList.refresh();
                }
            });
        }

        public Object[] getChildren(Object parentElement) {
            FeatureStructure featureStructure;
            LinkedList<FeatureValue> childs = new LinkedList<FeatureValue>();
            if (parentElement instanceof ModelFeatureStructure) {
                featureStructure = ((ModelFeatureStructure)parentElement).getStructre();
            } else if (parentElement instanceof FeatureValue) {
                FeatureValue value = (FeatureValue)parentElement;
                featureStructure = (FeatureStructure)value.getValue();
            } else {
                assert (false) : "Unexpected element!";
                return new Object[0];
            }
            Type type = featureStructure.getType();
            for (Feature feature : type.getFeatures()) {
                childs.add(new FeatureValue(this.mDocument, featureStructure, feature));
            }
            assert (childs.size() > 0);
            return childs.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IAdaptable && ((IAdaptable)element).getAdapter(FeatureStructure.class) != null) {
                return true;
            }
            if (element instanceof FeatureValue) {
                FeatureValue featureValue = (FeatureValue)element;
                if (featureValue.getFeature().getRange().isPrimitive()) {
                    Object value = featureValue.getValue();
                    if (value == null) {
                        return false;
                    }
                    if (value instanceof StringArray) {
                        StringArray array = (StringArray)featureValue.getValue();
                        return array.size() > 0;
                    }
                    return false;
                }
                return featureValue.getValue() != null;
            }
            assert (false) : "Unexpected element";
            return false;
        }

        @Override
        protected void addedAnnotation(Collection<AnnotationFS> annotations) {
            final LinkedList<ModelFeatureStructure> featureStructureList = new LinkedList<ModelFeatureStructure>();
            for (AnnotationFS annotation : annotations) {
                if (annotation.getType() != this.mCurrentType) continue;
                featureStructureList.add(new ModelFeatureStructure(this.mDocument, (FeatureStructure)annotation));
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureStructureBrowserViewPage.this.mFSList.add(featureStructureList.toArray());
                }
            });
        }

        @Override
        public void added(Collection<FeatureStructure> structures) {
            final LinkedList<ModelFeatureStructure> featureStructureList = new LinkedList<ModelFeatureStructure>();
            for (FeatureStructure structure : structures) {
                if (structure.getType() != this.mCurrentType) continue;
                featureStructureList.add(new ModelFeatureStructure(this.mDocument, structure));
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureStructureBrowserViewPage.this.mFSList.add(featureStructureList.toArray());
                }
            });
        }

        @Override
        protected void removedAnnotation(Collection<AnnotationFS> annotations) {
            final LinkedList<ModelFeatureStructure> featureStructureList = new LinkedList<ModelFeatureStructure>();
            for (AnnotationFS annotation : annotations) {
                if (annotation.getType() != this.mCurrentType) continue;
                featureStructureList.add(new ModelFeatureStructure(this.mDocument, (FeatureStructure)annotation));
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureStructureBrowserViewPage.this.mFSList.remove(featureStructureList.toArray());
                }
            });
        }

        @Override
        public void removed(Collection<FeatureStructure> structures) {
            final LinkedList<ModelFeatureStructure> featureStructureList = new LinkedList<ModelFeatureStructure>();
            for (FeatureStructure structure : structures) {
                if (structure.getType() != this.mCurrentType) continue;
                featureStructureList.add(new ModelFeatureStructure(this.mDocument, structure));
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureStructureBrowserViewPage.this.mFSList.remove(featureStructureList.toArray());
                }
            });
        }

        @Override
        protected void updatedAnnotation(Collection<AnnotationFS> annotations) {
        }

        @Override
        public void viewChanged(String oldViewName, String newViewName) {
            this.changed();
        }

        @Override
        public void changed() {
            FeatureStructureBrowserViewPage.this.mFSList.refresh();
        }
    }
}

